% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_intervals.R
\name{make_intervals}
\alias{make_intervals}
\title{Create Interval elements, most likely to add to a DataDictionary element.}
\usage{
make_intervals(closure = NULL, leftMargin = NULL, rightMargin = NULL,
  namespace = "4_3")
}
\arguments{
\item{closure}{The 'closure' attribute of each 'Interval' element to be created in order.}

\item{leftMargin}{The 'leftMargin' attribute of each 'Interval' element to be created in order.}

\item{rightMargin}{The 'rightMargin' attribute of each 'Interval' element to be created in order.}

\item{namespace}{The namespace of the PMML model}
}
\value{
PMML Intervals elements.
}
\description{
Create Interval elements, most likely to add to a DataDictionary element.
}
\details{
The 'Interval' element allows 3 attributes, all of which may be defined in the 'make_intervals'
function. The value of these attributes should be provided as a list. Thus the elements of the
'leftMargin' for example define the value of that attribute for each 'Interval' element in order.
}
\examples{
# make 3 Interval elements
# we define the 3 Intervals as ,1]  (1,2)  and [2,
mi <- make_intervals(
  list("openClosed", "openOpen", "closedOpen"),
  list(NULL, 1, 2), list(1, 2, NULL)
)
}
\seealso{
\code{\link{make_values}} to make Values child elements, \code{\link{add_data_field_children}}
to add these xml fragments to the DataDictionary PMML element.
}
\author{
Tridivesh Jena
}
