% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/pmml.nnet.R
\name{pmml.nnet}
\alias{pmml.nnet}
\title{Generate the PMML representation for a nnet object from package \pkg{nnet}.}
\usage{
\method{pmml}{nnet}(model, model_name = "NeuralNet_model",
  app_name = "SoftwareAG PMML Generator",
  description = "Neural Network Model", copyright = NULL,
  transforms = NULL, missing_value_replacement = NULL, ...)
}
\arguments{
\item{model}{A nnet object.}

\item{model_name}{A name to be given to the PMML model.}

\item{app_name}{The name of the application that generated the PMML.}

\item{description}{A descriptive text for the Header element of the PMML.}

\item{copyright}{The copyright notice for the model.}

\item{transforms}{Data transformations.}

\item{missing_value_replacement}{Value to be used as the 'missingValueReplacement'
attribute for all MiningFields.}

\item{...}{Further arguments passed to or from other methods.}
}
\value{
PMML representation of the nnet object.
}
\description{
Generate the PMML representation for a nnet object from package \pkg{nnet}.
}
\details{
This function supports both regression and classification neural
network models. The model is represented in the PMML NeuralNetwork format.
}
\examples{
library(nnet)
fit <- nnet(Species ~ ., data = iris, size = 4)
fit_pmml <- pmml(fit)

rm(fit)
}
\references{
\href{https://CRAN.R-project.org/package=nnet}{nnet: Feed-forward
Neural Networks and Multinomial Log-Linear Models (on CRAN)}
}
\author{
Tridivesh Jena
}
