% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/create_fframe.R
\name{create_fframe}
\alias{create_fframe}
\title{Add empty rows with time stamps to each cress-sectional unit in the panel}
\usage{
create_fframe(indata, timestamps, panel_ind = colnames(indata[, 1:2]),
  overwrite = FALSE)
}
\arguments{
\item{indata}{\code{data.frame} with a panel structure}

\item{timestamps}{\code{vector} of time IDs for the added time periods}

\item{panel_ind}{vector of length 2 indicating names of variables indexing
units and time periods respectively}

\item{overwrite}{logical; if TRUE, existing rows in the data are overwritten
with empty rows if their time ID is in timestamps}
}
\value{
A \code{data.frame} with empty rows added.
}
\description{
Creates a forecast frame as required by the \code{predict.pmpp()} method.
             To each cross-sectional unit in the data, a specified
             number of rows are added that contain only this unit's ID
             and the selected time ID.
}
\examples{
data(EmplUK, package = "plm")
EmplUK <- dplyr::filter(EmplUK, year \%in\% c(1978, 1979, 1980, 1981, 1982))
my_fframe <- create_fframe(EmplUK, 1983)
}
\author{
Michal Oleszak
}
