% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot_scm.R
\name{plot_scm}
\alias{plot_scm}
\title{Plot PsN SCM results.}
\usage{
plot_scm(dir, phase = "both", lineCol = "#902C10", lineType = 1,
  lineSize = 1, pointCol = "#902C10", pointShape = 16,
  pointSize = 3, textCol = "black", textSize = 5)
}
\arguments{
\item{dir}{A PsN SCM folder (containing \code{scmlog.txt}).}

\item{phase}{SCM phase. Can be \code{"both"} (the default), \code{"forward"} or \code{"backward"}.}

\item{lineCol}{Line color. Default is '#902C10'.}

\item{lineType}{Line type. Default is '1'.}

\item{lineSize}{Line color. Default is '1'.}

\item{pointCol}{Point color. Default is '#902C10'.}

\item{pointShape}{Point shape. Default is '16'.}

\item{pointSize}{Point size. Default is '3'.}

\item{textCol}{Point color. Default is 'black'.}

\item{textSize}{Point color. Default is '6'.}
}
\value{
A \code{\link{ggplot2}} plot object.
}
\description{
\code{plot_scm} returns a step-plot summary of a Perl-speaks-NONMEM (PsN, \url{https://uupharmacometrics.github.io/PsN/}) SCM (stepwise covariate modeling)
procedure. It depends on the presence of an \code{scmlog.txt} file in the
specified directory, and is inspired by the plot code provided with PsN 4.8.1.
}
\examples{
\dontrun{
scm <- plot_scm("E:/DrugX/ModelDevelopment/scm310")
}

}
\seealso{
NONMEM (\url{http://www.iconplc.com/innovation/nonmem/})

Lindbom L, Ribbing J & Jonsson EN (2004). Perl-speaks-NONMEM (PsN) - A Perl module for NONMEM related programming. Computer Methods and Programs in Biomedicine, 75(2), 85-94. \url{https://doi.org/10.1016/j.cmpb.2003.11.003}

Lindbom L, Pihlgren P & Jonsson N (2005). PsN-Toolkit - A collection of computer intensive statistical methods for non-linear mixed effect modeling using NONMEM. Computer Methods and Programs in Biomedicine, 79(3), 241-257. \url{https://doi.org/10.1016/j.cmpb.2005.04.005}
}
\author{
Justin Wilkins, \email{justin.wilkins@occams.com}
}
