% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calc_derived.R
\name{calc_derived}
\alias{calc_derived}
\alias{calc_derived_1cpt}
\alias{calc_derived_2cpt}
\alias{calc_derived_3cpt}
\title{Calculate derived pharmacokinetic parameters for a 1-, 2-, or 3-compartment
linear model.}
\usage{
calc_derived(..., verbose = FALSE)

calc_derived_1cpt(
  CL,
  V = NULL,
  V1 = NULL,
  ka = NULL,
  dur = NULL,
  tlag = NULL,
  tinf = NULL,
  dose = NULL,
  tau = NULL,
  step = 0.1,
  type = "all",
  sigdig = 5
)

calc_derived_2cpt(
  CL,
  V1 = NULL,
  V2,
  Q2 = NULL,
  V = NULL,
  Q = NULL,
  dur = NULL,
  tinf = NULL,
  ka = NULL,
  tlag = NULL,
  dose = NULL,
  tau = NULL,
  step = 0.1,
  type = "all",
  sigdig = 5
)

calc_derived_3cpt(
  CL,
  V1 = NULL,
  V2,
  V3,
  Q2 = NULL,
  Q3,
  V = NULL,
  Q = NULL,
  ka = NULL,
  dur = NULL,
  tinf = NULL,
  tlag = NULL,
  dose = NULL,
  tau = NULL,
  step = 0.1,
  type = "all",
  sigdig = 5
)
}
\arguments{
\item{...}{Passed to the other \code{calc_derived_*()} functions.}

\item{verbose}{For \code{calc_derived()}, provide a message indicating the
type of model detected.}

\item{CL}{Clearance (volume per time units, e.g. L/h)}

\item{V1, V}{Central volume of distribution (volume units, e.g. L).  Values
are synonyms; use only one.}

\item{ka}{Absorption rate (inverse time units, e.g. 1/h)}

\item{dur}{Duration of zero-order absorption (time units, e.g. h)}

\item{tlag}{Absorption lag time (time units, e.g. h)}

\item{tinf}{Duration of infusion (time units, e.g. h)}

\item{dose}{Dose (amount units, e.g. mg)}

\item{tau}{Duration of interdose interval (time units, e.g. h; defaults to 24)}

\item{step}{Time increment to use when estimating NCA parameters (time units, e.g. h; defaults to 0.1)}

\item{type}{Parameters to return. Default is \code{"all"}.  If not
\code{"all"}, this may be a vector from the names of the return value list.}

\item{sigdig}{Number of significant digits to be returned. Default is
\code{5}.}

\item{V2}{First peripheral volume of distribution (volume units, e.g. L)}

\item{Q2, Q}{Intercompartmental clearance from central to first peripheral
compartment (volume per time units, e.g. L/h).  Values are synonyms; use
only one.}

\item{V3}{Second peripheral volume of distribution (volume units, e.g. L)}

\item{Q3}{Intercompartmental clearance from central to second peripheral
compartment (volume per time units, e.g. L/h)}
}
\value{
Return a list of derived PK parameters for a 1-, 2-, or 3-compartment
  linear model given provided clearances and volumes based on the
  \code{type}. If a dose is provided, estimated non-compartmental analysis (NCA) parameters will
  be provided as well, based on simulation of single-dose and (if `tau` is specified) steady-state time courses.
\itemize{ 
  \item \code{Vss}: Volume of distribution at steady state, \eqn{V_{ss}} (volume units, e.g. L); 1-, 2-, and 3-compartment
  \item \code{k10}: First-order elimination rate, \eqn{k_{10}} (inverse time units, e.g. 1/h); 1-, 2-, and 3-compartment
  \item \code{k12}: First-order rate of transfer from central to first peripheral compartment, \eqn{k_{12}} (inverse time units, e.g. 1/h); 2- and 3-compartment
  \item \code{k21}: First-order rate of transfer from first peripheral to central compartment, \eqn{k_{21}} (inverse time units, e.g. 1/h); 2- and 3-compartment
  \item \code{k13}: First-order rate of transfer from central to second peripheral compartment, \eqn{k_{13}} (inverse time units, e.g. 1/h); 3-compartment
  \item \code{k31}: First-order rate of transfer from second peripheral to central compartment,\eqn{k_{31}} (inverse time units, e.g. 1/h); 3-compartment
  \item \code{thalf_alpha}: \eqn{t_{1/2,\alpha}} (time units, e.g. h); 1-, 2-, and 3-compartment
  \item \code{thalf_beta}: \eqn{t_{1/2,\beta}} (time units, e.g. h); 2- and 3-compartment
  \item \code{thalf_gamma}: \eqn{t_{1/2,\gamma}} (time units, e.g. h); 3-compartment
  \item \code{alpha}: \eqn{\alpha}; 1-, 2-, and 3-compartment
  \item \code{beta}: \eqn{\beta}; 2- and 3-compartment
  \item \code{gamma}: \eqn{\beta}; 3-compartment
  \item \code{trueA}: true A; 1-, 2-, and 3-compartment
  \item \code{trueB}: true B; 2- and 3-compartment
  \item \code{trueC}: true C; 3-compartment
  \item \code{fracA}: fractional A; 1-, 2-, and 3-compartment
  \item \code{fracB}: fractional B; 2- and 3-compartment
  \item \code{fracC}: fractional C; 3-compartment
  \item \code{AUCinf}: Area under the concentration-time curve to infinity (single dose)
  \item \code{AUCtau}: Area under the concentration-time curve over the dosing interval at steady state
  \item \code{Cmax}: Maximum concentration after a single dose
  \item \code{Cmaxss}: Maximum concentration over the dosing interval at steady state
  \item \code{Tmax}: Time after dose of maximum concentration 
  \item \code{AUCinf_dose_normalized}: Dose-normalized area under the concentration-time curve to infinity (single dose)
  \item \code{AUCtau_dose_normalized}: Dose-normalized area under the concentration-time curve over the dosing interval at steady state
  \item \code{Cmax_dose_normalized}: Dose-normalized maximum concentration after a single dose
  \item \code{Cmaxss_dose_normalized}: Dose-normalized maximum concentration over the dosing interval at steady state
  \item \code{step}: Time increment used when estimating NCA parameters.
 }

The input parameters with standardized names (\code{dose}, \code{V1}, \code{V2},
\code{V3}, \code{CL}, \code{Q2}, and \code{Q3}) are also returned in the
list, and if provided, additional PK parameters of `ka`, `tlag`, `tinf` and `dur` are also
returned in the list.  All inputs may be scalars or vectors.
}
\description{
Calculate derived pharmacokinetic parameters for a 1-, 2-, or 3-compartment
linear model.
}
\examples{
params <- calc_derived(CL=29.4, V1=23.4, V2=114, V3=4614, Q2=270, Q3=73)
params <- calc_derived_1cpt(CL=16, V=25)
params <- calc_derived_2cpt(CL=16, V1=25, V2=50, Q=0.5)
params <- calc_derived_3cpt(CL=29.4, V1=23.4, V2=114, V3=4614, Q2=270, Q3=73)
}
\references{
Shafer S. L. \code{CONVERT.XLS}

Rowland M, Tozer TN. Clinical Pharmacokinetics and
  Pharmacodynamics: Concepts and Applications (4th). Lippincott Williams &
  Wilkins, Philadelphia, 2010.
}
\author{
Justin Wilkins, \email{justin.wilkins@occams.com}

Bill Denney, \email{wdenney@humanpredictions.com}
}
