% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/combine.r
\name{combine_make_match_string}
\alias{combine_make_match_string}
\title{Mutate operation(s) in directory data.frame trade address column}
\usage{
combine_make_match_string(directory)
}
\arguments{
\item{directory}{A Scottish post office directory in the form of a data.frame
or other object that inherits from the data.frame class such as a
\code{\link[tibble]{tibble}}. Columns must at least include \code{forename},
\code{surname}, \code{address.trade.number}, \code{address.trade.body}.}
}
\value{
A data.frame of the same class as the one provided in \code{directory};
columns include at least \code{forename}, \code{surname}, \code{address.trade.number},
\code{address.trade.body}, \code{match.string}.
}
\description{
Creates a 'match.string' column in the provided Scottish post office
directory data.frame composed of entry(/ies) full name and trade address
pasted together. Missing trade address entry(/ies) are replaced with a
random generated string.
}
\section{Details}{

The purpose of the 'match.string' column is to facilitates the matching of
the general to trades directory down the line. It allows to calculate a
string distance metric between each pair of entries and match those falling
below a specified threshold.
}

\seealso{
\code{\link{combine_match_general_to_trades}} for the matching of
the general to trades directory.
}
