% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general.r
\name{general_clean_directory_plain}
\alias{general_clean_directory_plain}
\title{Mutate operation(s) in Scottish post office general directory data.frame
column(s)}
\usage{
general_clean_directory_plain(directory, verbose)
}
\arguments{
\item{directory}{A Scottish post office general directory in the form
of a data.frame or other object that inherits from the data.frame class
such as a \code{\link[tibble]{tibble}}. Columns must at least include
\code{forename}, \code{surname}, \code{occupation} and \code{addresses}.}

\item{verbose}{Whether the function should be executed silently (\code{FALSE}) or
not (\code{TRUE}).}
}
\value{
A data.frame of the same class as the one provided in \code{directory};
columns include at least \code{forename}, \code{surname}, \code{occupation},
\code{address.trade.number}, \code{address.trade.body}, \code{address.house.number} and
\code{address.house.body}. "house" suffix in \code{occupation} column is move to
\code{addresses}, occupation information is repatriated from \code{addresses} to
\code{occupation} column; \code{addresses} is split into trade and house address
column; additional records are created for each extra trade address
identified. Entries are further cleaned of optical character recognition
(OCR) errors and subject to a number of standardisation operations.
}
\description{
Attempts to clean the provided Scottish post office general directory
data.frame.
}
