% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.r
\name{utils_label_missing_addresses}
\alias{utils_label_missing_addresses}
\title{Label empty addresses as missing}
\usage{
utils_label_missing_addresses(directory)
}
\arguments{
\item{directory}{A directory dataframe. Columns must include
\code{address.house.number}, \code{address.house.number} and/or
\code{address.trade.number}, \code{address.trade.number}.}
}
\value{
A dataframe.
}
\description{
Labels empty address bodies as "not house/trade address found" in the
provided directory dataframe.
}
\examples{
\dontrun{
  directory <- data.frame(
    page = c("71", "71"),
    surname = c("ABOT", "ABRCROMBIE"), forename = c("Wm.", "Alex"),
    occupation = c("Wine and spirit merchant", "Baker"),
    address.number = c(" -; 1820", ""),
    address.body = c(
      "London st. ; house, Mary hill.*",
      ""
    ),
    stringsAsFactors = FALSE
  )
  utils_label_missing_addresses(directory)
}
}
