% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils.r
\name{utils_regmatches_if_found}
\alias{utils_regmatches_if_found}
\title{Conditionally amend character string vector.}
\usage{
utils_regmatches_if_found(
  string_filter,
  regex_filter,
  string_search,
  regex_search,
  default,
  ignore_case_filter,
  ignore_case_match,
  not
)
}
\arguments{
\item{string_filter}{Character string vector to search into for the pattern
provided in \code{regex_filter} above.}

\item{regex_filter}{Pattern to look for provided as a character string regex.}

\item{string_search}{Alternative character string to search into for the
pattern provided in \code{regex_search} above.}

\item{regex_search}{Alternative pattern provided as a character string regex
to look for in the alternative character string provided in \code{string_search}
below.}

\item{default}{Character string returned if pattern provided in \code{regex_filter}
not found.}

\item{ignore_case_filter}{Boolean specifying whether case should be ignored
(\code{TRUE}) or not (\code{FALSE}) in search for \code{regex_filter} in \code{string_filter}.}

\item{ignore_case_match}{Boolean specifying whether case should be ignored
(\code{TRUE}) or not (\code{FALSE}) in search for \code{regex_search} in \code{string_search}.}

\item{not}{Boolean specifying whether to negate the \code{regex_filter} search
pattern (\code{TRUE}) or not (\code{FALSE}).}
}
\value{
A character string vector.
}
\description{
Searches for specified pattern in provided character string vector. If found,
searches for alternative pattern in an alternative character string and returns
any match or an empty string if none. If original pattern not found, returns
the default character string provided.
}
\examples{
\dontrun{
  utils_regmatches_if_found(
    c("glasgow-entrepreneurs", "aberdeen-entrepreneurs"), "^glasgow",
    "edinburgh-entrepreneurs", "^.+(?=-)", "merchant", TRUE, TRUE, FALSE
  )
}
}
