% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/DispersalTemplate.R
\name{DispersalTemplate}
\alias{DispersalTemplate}
\title{R6 class representing a nested container for dispersal generator attributes}
\description{
\code{\link[R6:R6Class]{R6}} class representing a nested container for
\code{\link{DispersalGenerator}} attributes that are maintained when new model clones
are created. The container maintains \emph{input} and \emph{output} attribute names,
file, function and distribution templates, correlation parameters (for distribution
generation), rounding decimals, occupancy mask, and other
\code{\link{DispersalGenerator}} attributes that need to be maintained when cloning.
}
\examples{
dispersal_template <- DispersalTemplate$new()
dispersal_template$dispersal_breadth <- 130
dispersal_template$dispersal_proportion <- 0.4
coordinates <- data.frame(x = rep(1:4, 4), y = rep(1:4, each = 4))
dispersal_gen <- DispersalGenerator$new(
  coordinates = coordinates, inputs = c("dispersal_r"),
  generative_template = dispersal_template
)
dispersal_gen$dispersal_breadth
dispersal_gen$dispersal_proportion

}
\section{Super class}{
\code{\link[poems:GenerativeTemplate]{poems::GenerativeTemplate}} -> \code{DispersalTemplate}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{attached}}{A list of dynamically attached attributes (name-value pairs).}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{description}}{A brief description of what the generator generates.}

\item{\code{inputs}}{An array of input attribute names for the generator.}

\item{\code{outputs}}{An array of output attribute names for the generator.}

\item{\code{file_templates}}{A nested list of file template attributes.}

\item{\code{function_templates}}{A nested list of function template attributes.}

\item{\code{distribution_templates}}{A list of distribution template attributes.}

\item{\code{uses_correlations}}{A boolean to indicate that a \code{\link{SpatialCorrelation}} (or inherited class) object is used for generating correlated random deviates.}

\item{\code{spatial_correlation}}{A \code{\link{SpatialCorrelation}} (or inherited class) object for generating correlated random deviates.}

\item{\code{temporal_correlation}}{Absolute correlation coefficient between simulation time steps for all grid cells (0-1; default = 1).}

\item{\code{time_steps}}{Number of simulation time steps.}

\item{\code{decimals}}{Number of decimal places applied to generated data outputs (default: NULL = no rounding).}

\item{\code{occupancy_mask}}{Optional binary mask array (matrix), data frame, or raster (stack) for generated (time-series) data outputs.}

\item{\code{dispersal_friction}}{A \code{\link{DispersalFriction}} (or inherited class) object for dispersal distance multiplier data.}

\item{\code{distance_classes}}{Vector of distance interval boundaries (in km) for calculating discrete dispersal rates.}

\item{\code{max_distance_classes}}{The maximum number of distance classes when they are calculated automatically via the maximum distance (default: 1000).}

\item{\code{distance_scale}}{Scale of distance values in meters (default = 1). Usage: set to 1 for values in meters, or to 1000 for values in kilometers.}

\item{\code{distance_data}}{Data frame of distance classes including indices for the construction of compact matrices (columns: target_pop, source_pop, compact_row, distance_class).}

\item{\code{dispersal_function_data}}{Data frame of discrete dispersal function values. Optional first column may provide distance intervals (non-inclusive lower bounds).}

\item{\code{dispersal_proportion}}{Dispersal function: \emph{p*exp(-distance/b)} \emph{p} parameter. Represents the proportion and limit of dispersers between model cells.}

\item{\code{dispersal_breadth}}{Dispersal function: \emph{p*exp(-distance/b)} \emph{b} parameter. Represents the breadth of the dispersal between model cells. Typically estimated via average migration distance.}

\item{\code{dispersal_max_distance}}{Dispersal maximum distance or range (\emph{r}) parameter limits the use of the dispersal function: \emph{p*exp(-distance/b)}. The function is utilized when \emph{distance <= r} otherwise the dispersal rate is set to zero.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-DispersalTemplate-clone}{\code{DispersalTemplate$clone()}}
}
}
\if{html}{\out{
<details open><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="poems" data-topic="GenerativeTemplate" data-id="initialize"><a href='../../poems/html/GenerativeTemplate.html#method-GenerativeTemplate-initialize'><code>poems::GenerativeTemplate$initialize()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-DispersalTemplate-clone"></a>}}
\if{latex}{\out{\hypertarget{method-DispersalTemplate-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{DispersalTemplate$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
