% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/Validator.R
\name{Validator}
\alias{Validator}
\title{R6 class representing a pattern-oriented validator.}
\description{
\code{\link[R6:R6Class]{R6}} class for pattern-oriented validation and simulation
model ensemble selection. Pattern-oriented validation is a statistical
approach to compare patterns generated in simulations against observed
empirical patterns.

The class wraps functionality for the validation approach,
typically utilizing an external library, the default being the approximate Bayesian
computation (ABC) \code{\link[abc:abc]{abc}} library, and includes methods for
resolving non-finite metrics, centering and scaling the validator inputs, running
the validator analysis, and generating diagnostics (see \code{\link[abc:abc]{abc}}).
}
\examples{
# Example parameter sample data
sample_data <- data.frame(
  growth_rate_max = round(log(seq(1.11, 1.30, 0.01)), 3),
  harvest_rate = seq(0.11, 0.30, 0.01),
  initial_n = seq(105, 200, 5),
  density_max = seq(132, 170, 2)
)
# Example simulation result summary metrics
summary_metric_data <- data.frame(
  trend_n = seq(10, -9, -1),
  total_h = seq(70, 355, 15)
)
# Create a validator for selecting the 'best' example models
validator <- Validator$new(
  simulation_parameters = sample_data,
  simulation_summary_metrics = summary_metric_data,
  observed_metric_targets = c(trend_n = 0, total_h = 250),
  output_dir = tempdir()
)
suppressWarnings(validator$run(tolerance = 0.25, output_diagnostics = TRUE))
dir(tempdir(), "*.pdf") # plus validation diagnostics (see abc library documentation)
validator$selected_simulations # top 5 models

}
\section{Super classes}{
\code{\link[poems:GenericClass]{poems::GenericClass}} -> \code{\link[poems:GenericModel]{poems::GenericModel}} -> \code{Validator}
}
\section{Public fields}{
\if{html}{\out{<div class="r6-fields">}}
\describe{
\item{\code{attached}}{A list of dynamically attached attributes (name-value pairs).}
}
\if{html}{\out{</div>}}
}
\section{Active bindings}{
\if{html}{\out{<div class="r6-active-bindings">}}
\describe{
\item{\code{model_attributes}}{A vector of model attribute names.}

\item{\code{simulation_parameters}}{A data frame of sample model parameters for each simulation.}

\item{\code{simulation_summary_metrics}}{A data frame of result summary metrics for each simulation.}

\item{\code{observed_metric_targets}}{A vector of observed targets for each summary metric.}

\item{\code{random_seed}}{A seed for randomizing the order of the simulation samples (no randomization is utilized when left NULL).}

\item{\code{random_indices}}{Randomized simulation sample indices for the validator inputs and consequently the validator results when random seed is used.}

\item{\code{non_finite_replacements}}{A list of numeric values or function names (character strings) or direct assignments (assigned or loaded via source paths) for replacing NAs in specified (list names) summary metrics.}

\item{\code{input_center_scale_values}}{A nested list of center and scale values for validator input parameters/metrics.}

\item{\code{output_dir}}{Directory path for validator (default: \code{\link[abc:abc]{abc}}) regression diagnostic and other outputs.}

\item{\code{validation_call_function}}{Dynamically assigned function: \code{function(observed_metric_targets, simulation_parameters, simulation_summary_metrics, tolerance, method, ...)} for calling the validation function (default calls \code{\link[abc:abc]{abc}} library function).}

\item{\code{validator_return_object}}{Object returned by the validator function (see \code{\link[abc:abc]{abc}} documentation if using default).}

\item{\code{selected_simulations}}{A data frame of simulation sample indices and weights selected/assigned by the validation function (\code{\link[abc:abc]{abc}} by default).}

\item{\code{attribute_aliases}}{A list of alternative alias names for model attributes (form: \code{alias = "attribute"}) to be used with the set and get attributes methods.}

\item{\code{error_messages}}{A vector of error messages encountered when setting model attributes.}

\item{\code{warning_messages}}{A vector of warning messages encountered when setting model attributes.}
}
\if{html}{\out{</div>}}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-Validator-new}{\code{Validator$new()}}
\item \href{#method-Validator-run}{\code{Validator$run()}}
\item \href{#method-Validator-resolve_nonfinite_metrics}{\code{Validator$resolve_nonfinite_metrics()}}
\item \href{#method-Validator-center_scale_inputs}{\code{Validator$center_scale_inputs()}}
\item \href{#method-Validator-generate_diagnostics}{\code{Validator$generate_diagnostics()}}
\item \href{#method-Validator-clone}{\code{Validator$clone()}}
}
}
\if{html}{\out{
<details><summary>Inherited methods</summary>
<ul>
<li><span class="pkg-link" data-pkg="poems" data-topic="GenericModel" data-id="get_attribute"><a href='../../poems/html/GenericModel.html#method-GenericModel-get_attribute'><code>poems::GenericModel$get_attribute()</code></a></span></li>
<li><span class="pkg-link" data-pkg="poems" data-topic="GenericModel" data-id="get_attribute_aliases"><a href='../../poems/html/GenericModel.html#method-GenericModel-get_attribute_aliases'><code>poems::GenericModel$get_attribute_aliases()</code></a></span></li>
<li><span class="pkg-link" data-pkg="poems" data-topic="GenericModel" data-id="get_attribute_names"><a href='../../poems/html/GenericModel.html#method-GenericModel-get_attribute_names'><code>poems::GenericModel$get_attribute_names()</code></a></span></li>
<li><span class="pkg-link" data-pkg="poems" data-topic="GenericModel" data-id="get_attributes"><a href='../../poems/html/GenericModel.html#method-GenericModel-get_attributes'><code>poems::GenericModel$get_attributes()</code></a></span></li>
<li><span class="pkg-link" data-pkg="poems" data-topic="GenericModel" data-id="new_clone"><a href='../../poems/html/GenericModel.html#method-GenericModel-new_clone'><code>poems::GenericModel$new_clone()</code></a></span></li>
<li><span class="pkg-link" data-pkg="poems" data-topic="GenericModel" data-id="set_attributes"><a href='../../poems/html/GenericModel.html#method-GenericModel-set_attributes'><code>poems::GenericModel$set_attributes()</code></a></span></li>
</ul>
</details>
}}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Validator-new"></a>}}
\if{latex}{\out{\hypertarget{method-Validator-new}{}}}
\subsection{Method \code{new()}}{
Initialization method sets given attributes individually and/or from a list.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Validator$new(...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{...}}{Parameters passed via a \emph{params} list or individually.}

\item{\code{template}}{Template population model containing fixed (non-sampled) attributes.}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Validator-run"></a>}}
\if{latex}{\out{\hypertarget{method-Validator-run}{}}}
\subsection{Method \code{run()}}{
Pre-processes inputs, runs validator function for input parameters, and stores the function (and optionally diagnostic) outputs (see \code{\link[abc:abc]{abc}} documentation if using the default).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Validator$run(
  simulation_parameters = NULL,
  simulation_summary_metrics = NULL,
  observed_metric_targets = NULL,
  tolerance = 0.01,
  method = "neuralnet",
  output_diagnostics = FALSE,
  ...
)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{simulation_parameters}}{A data frame of sample model parameters for each simulation.}

\item{\code{simulation_summary_metrics}}{A data frame of result summary metrics for each simulation.}

\item{\code{observed_metric_targets}}{A vector of observed targets for each summary metric.}

\item{\code{tolerance}}{Tolerance or proportion of models to select.}

\item{\code{method}}{Validator algorithm to be applied (default is a neural network algorithm - see \code{\link[abc:abc]{abc}} documentation) .}

\item{\code{output_diagnostics}}{Boolean to indicate whether or not to output diagnostics (PDF file - default is FALSE).}

\item{\code{...}}{Additional validator parameters passed individually (see \code{\link[abc:abc]{abc}} documentation if using default).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Validator-resolve_nonfinite_metrics"></a>}}
\if{latex}{\out{\hypertarget{method-Validator-resolve_nonfinite_metrics}{}}}
\subsection{Method \code{resolve_nonfinite_metrics()}}{
Attempts to resolve any non-finite simulation summary metric values (and optionally changing them to NAs) via the non finite replacements parameter (a list of values/functions for replacing non-finite values).
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Validator$resolve_nonfinite_metrics(use_nas = TRUE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{use_nas}}{Boolean to indicate whether or not to replace all non-finite values with NAs (default is TRUE).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Validator-center_scale_inputs"></a>}}
\if{latex}{\out{\hypertarget{method-Validator-center_scale_inputs}{}}}
\subsection{Method \code{center_scale_inputs()}}{
Centers and scales the model parameters, result summary metrics and observed targets.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Validator$center_scale_inputs()}\if{html}{\out{</div>}}
}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Validator-generate_diagnostics"></a>}}
\if{latex}{\out{\hypertarget{method-Validator-generate_diagnostics}{}}}
\subsection{Method \code{generate_diagnostics()}}{
Generates the validation diagnostics (see \code{\link[abc:abc]{abc}} documentation if using default) as a PDF file in the output directory.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Validator$generate_diagnostics(output_dir = NULL)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{output_dir}}{Output directory path for the diagnostics PDF file (must be present if not already set within validator class object).}
}
\if{html}{\out{</div>}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-Validator-clone"></a>}}
\if{latex}{\out{\hypertarget{method-Validator-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{Validator$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
