% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/all_passed.R
\name{all_passed}
\alias{all_passed}
\title{Did all of the validations fully \emph{pass}?}
\usage{
all_passed(agent, i = NULL)
}
\arguments{
\item{agent}{An agent object of class \code{ptblank_agent}.}

\item{i}{A vector of validation step numbers. These values are assigned to
each validation step by \strong{pointblank} in the order of definition. If
\code{NULL} (the default), all validation steps will be used for the evaluation
of complete \emph{passing}.}
}
\value{
A logical value.
}
\description{
Given an agent's validation plan that had undergone interrogation via
\code{\link[=interrogate]{interrogate()}}, did every single validation step result in zero \emph{failing}
test units? Using the \code{all_passed()} function will let us know whether that's
\code{TRUE} or not.
}
\details{
The \code{all_passed()} function provides a single logical value based on an
interrogation performed in the \emph{agent}-based workflow. For very large-scale
validation (where data quality is a known issue, and is perhaps something to
be tamed over time) this function is likely to be less useful since it is
quite stringent (all test units must pass across all validation steps).

Should there be a requirement for logical values produced from validation, a
more flexible alternative is in using the test (\verb{test_*()}) variants of the
validation functions. Each of those produce a single logical value and each
and have a \code{threshold} option for failure levels. Another option is to
utilize post-interrogation objects within the \emph{agent}'s x-list (obtained by
using the \code{\link[=get_agent_x_list]{get_agent_x_list()}} function). This allows for many possibilities
in producing a single logical value from an interrogation.
}
\section{Examples}{


Create a simple table with a column of numerical values.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{tbl <- dplyr::tibble(a = c(4, 5, 7, 8))

tbl
#> # A tibble: 4 x 1
#>       a
#>   <dbl>
#> 1     4
#> 2     5
#> 3     7
#> 4     8
}\if{html}{\out{</div>}}

Validate that values in column \code{a} are always greater than 4.

\if{html}{\out{<div class="sourceCode r">}}\preformatted{agent <-
  create_agent(tbl = tbl) \%>\%
  col_vals_gt(columns = vars(a), value = 3) \%>\%
  col_vals_lte(columns = vars(a), value = 10) \%>\%
  col_vals_increasing(columns = vars(a)) \%>\%
  interrogate()
}\if{html}{\out{</div>}}

Determine if these column validations have all passed by using \code{all_passed()}
(they do).

\if{html}{\out{<div class="sourceCode r">}}\preformatted{all_passed(agent = agent)
}\if{html}{\out{</div>}}

\if{html}{\out{<div class="sourceCode">}}\preformatted{#> [1] TRUE
}\if{html}{\out{</div>}}
}

\section{Function ID}{

8-4
}

\seealso{
Other Post-interrogation: 
\code{\link{get_agent_x_list}()},
\code{\link{get_data_extracts}()},
\code{\link{get_sundered_data}()},
\code{\link{write_testthat_file}()}
}
\concept{Post-interrogation}
