% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/agent_ops.R
\name{agent_write}
\alias{agent_write}
\title{Write an agent to disk}
\usage{
agent_write(agent, filename, path = NULL, keep_tbl = FALSE)
}
\arguments{
\item{agent}{An \emph{agent} object of class \code{ptblank_agent} that is created with
\code{\link[=create_agent]{create_agent()}}.}

\item{filename}{The file name to create on disk for the \code{agent}.}

\item{path}{An optional path to which the file should be saved (combined with
\code{filename}).}

\item{keep_tbl}{An option to keep a data table that is associated with the
\emph{agent} (which is the case when the \emph{agent} is created using
\verb{create_agent(tbl = <data table, ...)}). The default is \code{FALSE} where the
data table is removed before writing to disk. For database tables of the
class \code{tbl_dbi} and for Spark DataFrames (\code{tbl_spark}) the table is always
removed (even if \code{keep_tbl} is set to \code{TRUE}).}
}
\description{
Writing an \emph{agent} to disk with \code{agent_write()} is good practice for keeping
data validation intel close at hand for later retrieval (with
\code{\link[=agent_read]{agent_read()}}). By default, any data table that the \emph{agent} may have before
being committed to disk will be expunged. This behavior can be changed by
setting \code{keep_tbl} to \code{TRUE} but this only works in the case where the table
is not of the \code{tbl_dbi} or the \code{tbl_spark} class.
}
\details{
It can be helpful to set a table-reading function to later reuse the \emph{agent}
when read from disk through \code{\link[=agent_read]{agent_read()}}. This can be done with the
\code{read_fn} argument of \code{\link[=create_agent]{create_agent()}} or, later, with \code{\link[=set_read_fn]{set_read_fn()}}.
Alternatively, we can reintroduce the \emph{agent} to a data table with the
\code{\link[=set_tbl]{set_tbl()}} function.
}
