% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulation.R
\name{sim_two_stage}
\alias{sim_two_stage}
\title{Simulate Two-Stage Data}
\usage{
sim_two_stage(
  n = 10000,
  par = c(gamma = 0.5, beta = 1),
  seed = NULL,
  action_model_1 = function(C_1, beta, ...) stats::rbinom(n = NROW(C_1), size = 1, prob =
    lava::expit(beta * C_1)),
  action_model_2 = function(C_2, beta, ...) stats::rbinom(n = NROW(C_1), size = 1, prob =
    lava::expit(beta * C_2)),
  deterministic_rewards = FALSE
)
}
\arguments{
\item{n}{Number of observations.}

\item{par}{Named vector with distributional parameters.
\itemize{
\item{} \code{gamma}: \eqn{\gamma}
\item{} \code{beta}: \eqn{\beta}
}}

\item{seed}{Integer.}

\item{action_model_1}{Function used to specify the action/treatment at stage 1.}

\item{action_model_2}{Function used to specify the action/treatment at stage 2.}

\item{deterministic_rewards}{Logical. If TRUE, the deterministic reward
contributions are returned as well (columns U_1_A0, U_1_A1, U_2_A0, U_2_A1).}
}
\value{
\link{data.table} with n rows and columns B, BB, L_1, C_1, A_1, L_2, C_2,
A_2, L_3, U_1, U_2, U_3 (,U_1_A0, U_1_A1, U_2_A0, U_2_A1).
}
\description{
Simulate Two-Stage Data
}
\details{
\code{sim_two_stage} samples \code{n} iid observation
\eqn{O} with the following distribution:
\eqn{BB} is a random categorical variable with levels \code{group1},
\code{group2}, and \code{group3}. Furthermore,
\deqn{
B \sim \mathcal{N}(0,1)\\
L_{1} \sim \mathcal{N}(0, 1)\\
C_{1} \mid L_{1} \sim \mathcal{N}(L_1, 1)\\
A_1 \mid C_1 \sim Bernoulli(expit(\beta C_1))\\
L_{2} \sim \mathcal{N} (0, 1)\\
C_{2} \mid A_1, L_1 \sim \mathcal{N}(\gamma L_1 + A_1, 1)\\
A_2 \mid C_2 \sim Bernoulli(expit(\beta C_2))\\
L_{3} \sim \mathcal{N} (0, 1)
}
The rewards are calculated as
\deqn{
U_1 = L_1\\
U_2 = A_1\cdot C_1 + L_2 \\
U_3 = A_2\cdot C_2 + L_3.
}
}
