% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/linguee_word_translation.R
\name{linguee_word_translation}
\alias{linguee_word_translation}
\title{Translate word using Linguee Translation API}
\usage{
linguee_word_translation(
  word,
  target_language,
  source_language,
  guess_direction = FALSE,
  follow_corrections = "always"
)
}
\arguments{
\item{word}{This is the word that you want to translate.}

\item{target_language}{This is the language that you want to translate the word into.}

\item{source_language}{This is the language of the word that you want to translate.}

\item{guess_direction}{Specifies whether the API should guess the translation direction when the source language is set to "auto".
The default value is FALSE.}

\item{follow_corrections}{Specifies whether the API should include translations that have been marked as corrections.
The default value is "always" to include corrections.}
}
\value{
Translated word options.
}
\description{
Translate word using Linguee Translation API
}
\examples{
\donttest{
linguee_word_translation("hello", target_language = "es", source_language = "en")
}
}
