% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/google_translate_long_text.R
\name{google_translate_long_text}
\alias{google_translate_long_text}
\title{Translate long text using Google Translate}
\usage{
google_translate_long_text(
  text,
  target_language = "en",
  source_language = "auto",
  chunk_size = 1000
)
}
\arguments{
\item{text}{The long text to translate. Should be a single string.}

\item{target_language}{The language to translate the text into. Default is "en" for English.}

\item{source_language}{The language of the input text. Default is "auto" for automatic detection.}

\item{chunk_size}{The maximum number of characters to send in a single translation request. Default is 1000.}
}
\value{
A single string containing the translated text.
}
\description{
This function translates long text from one language to another using Google Translate.
It splits the text into smaller chunks if necessary to handle large inputs.
}
\examples{
\dontrun{
long_text <- paste(rep("This is a long text to translate.", 100), collapse = " ")
google_translate_long_text(
long_text, target_language = "de",
source_language = "en",
chunk_size = 500)
}
}
