% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/cv.polywog.r
\name{cv.polywog}
\alias{cv.polywog}
\title{Cross-validation of polynomial degree and penalization factor}
\usage{
cv.polywog(formula, ..., degrees.cv = 1:3, nfolds = 10, model = TRUE,
  X = FALSE, y = FALSE)
}
\arguments{
\item{formula}{model formula specifying the response and input variables.}

\item{...}{other arguments to be passed to \code{\link{polywog}}.  Arguments
related to the bootstrap will be ignored, as bootstrapping must be
performed separately.}

\item{degrees.cv}{vector of polynomial degrees to examine via
cross-validation.}

\item{nfolds}{number of folds to use in cross-validation.}

\item{model}{logical: whether to include the model frame in the
\code{"polywog"} object included in the output.}

\item{X}{logical: whether to include the raw model matrix (i.e., the
matrix of input variables prior to taking their polynomial expansion) in
the \code{"polywog"} object included in the output.}

\item{y}{logical: whether to include the response variable in the
\code{"polywog"} object included in the output.}
}
\value{
An object of class \code{"cv.polywog"}, a list containing:
\describe{
  \item{\code{results}}{A table of each degree tested, the optimal
penalization factor \eqn{\lambda} for that degree, and its
cross-validation error.}
  \item{\code{degree.min}}{The polynomial degree giving the lowest
cross-validation error.}
  \item{\code{polywog.fit}}{A \code{\link{polywog}} model, fit at the
polynomial degree giving the lowest cross-validation error.}
}

Because the returned object contains the fitted polywog model for the
optimal degree, no additional runs of \code{\link{polywog}} are necessary
to estimate coefficients or the penalization factor \eqn{\lambda}.
However, bootstrap results must be obtained by running
\code{\link{bootPolywog}} on the \code{"polywog.fit"} element of the
returned object, as in the examples below.
}
\description{
k-fold cross-validation to select the polynomial degree and penalization
factor for a \code{\link{polywog}} model.
}
\details{
When fitting with \code{method = "scad"}, different fold assignments are
used for each polynomial degree specified, because \code{\link{cv.ncvreg}}
does not allow for custom fold assignments.  This may affect the accuracy
of the estimated cross-validation error for each degree.  When
\code{method = "scad"}, the calls to \code{\link{polywog}} made by
\code{cv.polywog} will issue warnings that the \code{foldid} argument is
being ignored.
}
\examples{
## Using occupational prestige data
data(Prestige, package = "carData")
Prestige <- transform(Prestige, income = income / 1000)

## Examine degrees 1 through 4
## (note: using low convergence threshold to shorten computation time of the
## example, *not* recommended in practice!)
set.seed(39)
cv1 <- cv.polywog(prestige ~ education + income + type,
                  data = Prestige,
                  degrees.cv = 1:4,
                  nfolds = 10,
                  thresh = 1e-4)
print(cv1)

## Extract best model and bootstrap
fit1 <- cv1$polywog.fit
fit1 <- bootPolywog(fit1, nboot = 5)
summary(fit1)
}
\author{
Brenton Kenkel and Curtis S. Signorino
}
