% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/policy.R
\name{policy}
\alias{policy}
\title{Extract the Policy from a POMDP/MDP}
\usage{
policy(x)
}
\arguments{
\item{x}{A solved POMDP object.}
}
\value{
A list with the policy for each epoch. %% ~Describe the value
returned %% If it is a LIST, use %% \item{comp1 }{Description of 'comp1'} %%
\item{comp2 }{Description of 'comp2'} %% ...
}
\description{
Extracts the policy from a solves POMDP/MDP.
}
\details{
A list (one entry per epoch) with the optimal policy. The policy is a data
frame consisting of three parts.

Part 1: The value function with one column per state. (For MDPs this is just
one column with the state).

Part 2: One column with the optimal action.

Part 3: One column per observation with the index of the row representing
the policy node in the next epoch.
}
\examples{

data("Tiger")
sol <- solve_POMDP(model = Tiger)
sol

# policy with value function, optimal action and transitions for observations.
policy(sol)

}
\author{
Michael Hahsler
}
\keyword{graphs}
