% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/regret.R
\name{regret}
\alias{regret}
\title{Calculate the Regret of a Policy}
\usage{
regret(policy, benchmark, start = NULL)
}
\arguments{
\item{policy}{a solved POMDP containing the policy to calculate the regret for.}

\item{benchmark}{a solved POMDP with the (optimal) policy. Regret is calculated relative to this
policy.}

\item{start}{the used start (belief) state. If NULL then the start (belief) state of the \code{benchmark} is used.}
}
\value{
the regret as a difference of expected long-term rewards.
}
\description{
Calculates the regret of a policy relative to a benchmark policy.
}
\details{
Regret is defined as \eqn{V^{\pi^*}(s_0) - V^{\pi}(s_0)} with \eqn{V^\pi} representing the expected long-term
state value (represented by the value function) given the policy \eqn{\pi} and the start
state \eqn{s_0}. For POMDPs the start state is the start belief \eqn{b_0}.

Note that for regret usually the optimal policy \eqn{\pi^*} is used as the benchmark.
Since the optimal policy may not be known, regret relative to the best known policy can be used.
}
\examples{
data(Tiger)

sol_optimal <- solve_POMDP(Tiger)
sol_optimal

# perform exact value iteration for 10 epochs
sol_quick <- solve_POMDP(Tiger, method = "enum", horizon = 10)
sol_quick

regret(sol_quick, benchmark = sol_optimal)
}
\seealso{
Other POMDP: 
\code{\link{MDP2POMDP}},
\code{\link{POMDP}()},
\code{\link{accessors}},
\code{\link{actions}()},
\code{\link{add_policy}()},
\code{\link{plot_belief_space}()},
\code{\link{projection}()},
\code{\link{reachable_and_absorbing}},
\code{\link{sample_belief_space}()},
\code{\link{simulate_POMDP}()},
\code{\link{solve_POMDP}()},
\code{\link{solve_SARSOP}()},
\code{\link{transition_graph}()},
\code{\link{update_belief}()},
\code{\link{value_function}()},
\code{\link{write_POMDP}()}

Other MDP: 
\code{\link{MDP}()},
\code{\link{MDP2POMDP}},
\code{\link{MDP_policy_functions}},
\code{\link{accessors}},
\code{\link{actions}()},
\code{\link{add_policy}()},
\code{\link{gridworld}},
\code{\link{reachable_and_absorbing}},
\code{\link{simulate_MDP}()},
\code{\link{solve_MDP}()},
\code{\link{transition_graph}()},
\code{\link{value_function}()}
}
\author{
Michael Hahsler
}
\concept{MDP}
\concept{POMDP}
