\name{NEWS}
\title{News for package `pomp'}
\section{Changes in \pkg{pomp} version 1.16}{
  \itemize{
    \item The bug reported in issue #57 has been fixed.
    \item A bug arising when building pomp objects with Csnippets in certain Windows configurations has been fixed.
    \item Issue #56, in which covariate names are discarded when coercing a pomp object to a data frame, has been fixed.
    Thanks to Eamon O'Dea for reporting this bug.
    \item More informative error messages are given when \code{bake} or \code{freeze} return \code{NULL}.
    In such a case, these functions now generate a warning and return a character-string message, with attributes.
    \item Improve documentation of \code{traj.match}, in response to Issue #57.
    \item A new facility, \code{gillespie.hl.sim}, allows implementation of Gillespie's algorithm for exact stochastic simulation of continuous-time Markov processes via a streamlined C snippet interface.
    \item The old facility for Gillespie simulations, \code{gillespie.sim}, now accepts C snippets for faster calculation of event rates.
    \item The old \code{skeleton.type} and \code{skelmap.delta.t} arguments of the \code{pomp} constructor, which have generated error messages since version 1.9.2, have been done away with completely.
    \item Eamon O'Dea identified a bug (Issue #54) occurring when \code{pomp} is called with a single-row data frame.
    This has been fixed using his contributed patch.
  }
}
\section{Changes in \pkg{pomp} version 1.15}{
  \itemize{
    \item A new \code{dmultinom} function is provided in \sQuote{pomp.h}.
    This provides the probability distribution function for the multinomial distribution.
    \item Improved tests.
    \item Fixed bugs emerging in R-devel due to refactoring of underlying \R source code.
  }
}
\section{Changes in \pkg{pomp} version 1.14}{
  \itemize{
    \item Eamon O'Dea pointed out that the bug in \code{gillespie.sim}, addressed by version 1.12.3, was not completely fixed.
    This problem has now been resolved.
    In addition, covariates are now guaranteed to be evaluated at least once per observation interval.
    \item The new argument \code{hmax} to \code{gillespie.sim} allows the user to specify the maximum step size that will be taken before covariates are evaluated.
    \item The K-leap method has been removed.
    Its accuracy is low on test problems and it is difficult to make it compatible with the pomp paradigm.
    In particular, it does not readily accomodate time-varying covariates in a sensible way, nor does it lend itself to simulations at pre-specified times.
    \item \code{bspline.basis} and \code{periodic.bspline.basis} now take an optional non-negative integer argument \code{deriv}.
    When \code{deriv > 0}, the order-\code{deriv} derivative of each basis function is returned.
    \item A new function, \code{periodic_bspline_basis_eval_deriv}, has been added to the C API.
    This function gives access, at the C level, to evaluation of the derivatives of periodic B-splines.
    \item Upgrade license to GPL version 3.
    \item Fix buffer-flow problem identified by \code{valgrind}.
  }
}
\section{Changes in \pkg{pomp} version 1.13}{
  \itemize{
    \item Fix bug found by Eamon O'Dea in \code{gillespie.sim}.
    \item Fix bug in \code{onestep.sim}.
    \item The Ricker example has a new parameter, \eqn{c}, which scales the (unobserved) population size.
    By default, \eqn{c=1}, so that the behavior is as before.
    \item Improved error trapping.
  }
}
\section{Changes in \pkg{pomp} version 1.12}{
  \itemize{
    \item Some changes have been made to the use of random numbers in some codes (the stochastic simulations in \code{gillespie.sim} and the resampling in the particle-filtering codes).
    These changes will mean that calculations performed before will not be reproducible in perfect detail, but will be statistically equivalent.
    \item Minor changes in C codes to obviate warnings generated by T. Kalibera's \code{rchk} checks.
    \item The rare and fascinating \dQuote{Bug of St. Patrick} has been fixed.
    Thanks to Carles Breto for finding the bug and helping to isolate it.
    \item More informative error messages are generated when \code{dmeasure} returns a non-finite likelihood in any of the particle filtering codes.
    \item Some streamlining of codes.
  }
}
\section{Changes in \pkg{pomp} version 1.11}{
  \itemize{
    \item Callable routines are now registered.
    \item The functions \code{bake}, \code{stew}, and \code{freeze} now preserve information about the system time used in computation as an attribute of the returned object.
    In addition, these functions store information about the RNG settings.
    \item Some documentation improvements, courtesy of Sebastian Funk.
    \item Various documentation improvements.
    \item More verbosity is provided with \code{verbose=TRUE}.
    \item Better handling of \code{pomp}'s \code{times} argument.
  }
}
\section{Changes in \pkg{pomp} version 1.10}{
  \itemize{
    \item New \code{logLik} method for \code{pmcmcList} objects.
    \item The deprecated option to supply a matrix or numeric vector as the \code{data} argument to \code{pomp} have been removed and an error is now generated.
    \code{data} must be provided as either a data frame or an object of class \code{pomp}.
    See \code{?pomp} for details.
    \item The deprecated \code{skeleton.type} and \code{skelmap.delta.t} arguments to \code{pomp} have been removed.
    Using these arguments will now generate an error message.
    The correct method of specifiying the deterministic skeleton is now explained in the help pages (\code{?pomp}).
    \item Source code fixes to eliminate warnings during compilation.
    \item Improved test suite.
    \item Minor documentation correction.
  }
}
\section{Changes in \pkg{pomp} version 1.9}{
  \itemize{
    \item During particle filtering, when non-finite \code{dmeasure} values are generated, an error is generated and the offending parameters, states, data, and time are reported.
    In methods that use parameter transformations (\code{transform=TRUE}), the reported parameters were on the transformed (estimation) scale, which can be confusing.
    The error message now gives the parameters on the natural (model) scale.
    \item Modified \file{src/ssa.c} to fix UBSAN errors.
    \item C codes have been modified to take advantage of changes to the \R API (R SVN REVISION 71180).
    \item A bug in \code{mif2} arising when filtering fails in the final timestep has been fixed.
    In this case, when all particles are deemed inconsistent with the data, we use an unweighted mean (with a warning) in place of the default weighted mean.
    \item C codes have been modified to take advantage of changes to the \pkg{R} API (R SVN REVISION 71180).
    \item Modified \file{src/ssa.c} to fix UBSAN errors.
  }
}
\section{Changes in \pkg{pomp} version 1.8}{
  \itemize{
    \item There is a new option, \code{shlib.args}, to \code{pomp}.
    This allows arbitrary options to be passed to the compiler when C snippets are used.
    In particular, one can link a library of C snippets against a precompiled static library.
    \item In Sobol' sequence generation (\code{sobolDesign}, \code{profileDesign}), we now use the suggestion of Joe & Kuo (2003) to choose a better sequence start point.
    \item The generation of Sobol' sequences (\code{sobolDesign}, \code{profileDesign}) is now performed using the \pkg{NLopt} routines written in C instead of the original \acronym{TOMS} 659 FORTRAN codes.
    The copyright notices are located in the source code.
    \item The stochastic simulation algorithms underlying the Gillespie and K-leap methods (\code{gillespie.sim}, \code{kleap.sim}) have been refactored in C.
    In addition, errors due to accumulation of round-off error have been repaired.
    The result will be more accurate, but somewhat slower when there are a very large number of reactions.
    \item Fixed a bug in \code{plot} on \code{pomp} objects with more than 10 variables to plot.
    \item Refactored \code{rw.sd} for greater stability.
    \item Modified the \dQuote{dacca} example to use C snippets.
    \item Made Sobol' codes more robust.
    \item Modified the demos to use best practices.
    \item Further improvements to the test suite.
    Code coverage is now 100\%.
  }
}  
\section{Changes in \pkg{pomp} version 1.7}{
  \itemize{
    \item Improvement of the test suite and of error messages.
    \item Improve the \code{show} and \code{print} methods for \code{pomp} objects.
    \item Some internal refactoring.
    \item Improve error messages for missing basic components.
    \item Fix typos in one of the help-page examples.
    \item Several obscure bug-fixes.
    \item Add some references.
  }
}
\section{Changes in \pkg{pomp} version 1.6}{
  \itemize{
    \item Major revisions to the package help pages and manual.
    The separate documentation on C snippets and process-model plugins has been merged into the main \code{pomp} help page, which now has comprehensive instructions on building a \code{pomp} object.
    \item Update to the package help page.
    \item New methods for the Ensemble Kalman Filter (\code{enkf}) and Ensemble Adjustment Kalman Filter (\code{eakf}) have been added to the package.
    \item There is a new plugin for \code{rprocess} called \code{kleap.sim}.
    This implements the so-called \dQuote{K-leap method} of Cai & Xu (2007).
    \item Major overhaul of error handling system and to error and warning messages.
    Many more errors are now trapped and reported with more informative messages.
    \item The matrix and numeric vector options for the \code{data} argument to \code{pomp} are now deprecated and will be removed in a future release.
    In calls to \code{pomp}, \code{data} should be either a data frame or a \code{pomp}-class object.
    \item In \code{mif2}, it is now required that \code{Nmif>0}.
    \item Redundant \code{bootstrap} argument to \code{nlf} has been removed.
    \item Many improvements to the test suite to obtain better code coverage.
    \item Fixed bugs that might arise in rare circumstances in \code{simulate} and \code{eulermultinom} functions.
    \item Fixed a bug in \code{pompExample}.
    \item Fixed several small, rare bugs found as a result of improved testing.
    \item Fixed bug in specification of skeleton in pompExamples.
    \item \code{pomp} is no longer an S4 method.
    Its new status as an ordinary function abbreviates and consolidates the code and simplifies the documentation.
    \item A bug restricting access in C code to \code{userdata} has been fixed.
    \item Fixed bug in \code{pompExample(...,show=TRUE)}.
  }
}
\section{Changes in \pkg{pomp} version 1.5}{
  \itemize{
    \item A better interface for specifying a model's deterministic skeleton is provided.
    One specifies \code{skeleton=map(f,delta.t)} for a discrete-time skeleton (a map) and \code{skeleton=vectorfield(f)} for a continuous-time skeleton (a vectorfield).
    The old arguments \code{skeleton.type} and \code{skelmap.delta.t} are deprecated and will be removed in a future release.
    \item The \code{pfilter} help page has been improved.
    Specifically, the discussion of filtering failures is better.
    \item Miscellaneous improvements to the help pages.
    \item \code{mif2} no longer computes filter means.
    \item The new argument \code{show} of \code{pompExamples} allows one to display the example code instead of executing it.
    \item The minimum version of \R supported is now 3.1.2.
    \item \code{init.state} now has the optional argument \code{nsim}.
    Using this, one can request multiple initial state vectors per parameter vector.
    \item \code{pfilter} now uses less memory when it is asked to run at a single point in parameter space.
    \item A bug associated with the \code{rw.sd} argument to \code{mif2} on Windows platforms has been fixed.
    \item The \code{method="mif2"} option to \code{mif} has been removed.
    Use \code{mif2} instead.
    \item The \code{particles} method (rarely if ever used), has been removed to streamline the \code{mif} codes.
    \item The \code{method="mif2"} option to \code{mif} is now deprecated.
    It will be removed in a future release.
    Use \code{mif2} instead.
  }
}
\section{Changes in \pkg{pomp} version 1.4}{
  \itemize{
    \item Following the publication of the Journal of Statistical Software announcement paper, the \file{CITATION} has been modified to include the appropriate citation.
    Please use \code{citation("pomp")} to learn about how to cite \pkg{pomp} correctly.
    \item \code{conv.rec} on the results of a \code{mif2} computation now play nicely with \code{reshape2::melt}.
    \item It is now possible to direct \code{pomp} to place \code{Csnippet} codes in a specified location.
    This is accomplished via the new \code{cdir} and \code{cfile} arguments to \code{pomp}.
    \item When several concurrent \R processes attempt to simultaneously compile \code{Csnipet} code from copies of a \code{pomp} object on the same machine, a race condition exists.
    This release fixes this by ensuring that \code{Csnippet} codes are written and compiled in a process-specific directory.
  }
}
\section{Changes in \pkg{pomp} version 1.3}{
  This release removes several long-deprecated features.
  \itemize{
    \item The \code{seed} argument to \code{pfilter} has been removed.
    Use \code{freeze} to obtain similar functionality.
    \item The redundant \code{pars} argument to \code{mif} has been removed.
    Names of parameters to be estimated are taken from the nonzero entries of \code{rw.sd}.
    Initial-value parameters are designated using the \code{ivps} argument.
    \item The old \code{parameter.transform} and \code{parameter.inv.transform} arguments to \code{pomp} have been removed.
    They were superseded by the arguments \code{fromEstimationScale} and \code{toEstimationScale} in version 0.65-1.
    \item Some internal changes to \code{mif2} by C. Breto, in support of panel methods under development.
  }
}
\section{Changes in \pkg{pomp} version 1.2}{
  \itemize{
    \item Bug fix: for POMPs with a scalar state variable, the \code{filter.mean}, \code{pred.mean}, and \code{pred.var} methods dropped the singleton dimension of the respective arrays, in conflict with the assumptions of certain \code{plot} methods.
    This resolves issue #3.
    \item Documentation improvements.
    Specifically, the details of how step-sizes are chosen in the \code{euler.sim}, \code{discrete.time.sim}, and \code{onestep.sim} plugins has been spelled out explicitly.
    Also, incompleteness in the \code{sannbox} documentation has been corrected.
    \item Provide \code{filter.traj} method for \code{pmcmcList} objects.
    \item Fixed a bug in \code{mif} and \code{mif2} when \code{cooling.type="hyperbolic"} and \code{cooling.fraction.50=1}.
  }
}
