% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/probe.R, R/probe_match.R, R/objfun.R
\docType{methods}
\name{probe}
\alias{probe}
\alias{probe,missing-method}
\alias{probe,ANY-method}
\alias{probe,data.frame-method}
\alias{probe,pomp-method}
\alias{probe,probed_pomp-method}
\alias{probe,probe_match_objfun-method}
\alias{probe,objfun-method}
\title{Probes (AKA summary statistics)}
\usage{
\S4method{probe}{data.frame}(
  data,
  probes,
  nsim,
  seed = NULL,
  params,
  rinit,
  rprocess,
  rmeasure,
  ...,
  verbose = getOption("verbose", FALSE)
)

\S4method{probe}{pomp}(
  data,
  probes,
  nsim,
  seed = NULL,
  ...,
  verbose = getOption("verbose", FALSE)
)

\S4method{probe}{probed_pomp}(
  data,
  probes,
  nsim,
  seed = NULL,
  ...,
  verbose = getOption("verbose", FALSE)
)

\S4method{probe}{probe_match_objfun}(data, seed, ..., verbose = getOption("verbose", FALSE))

\S4method{probe}{objfun}(data, seed = NULL, ...)
}
\arguments{
\item{data}{either a data frame holding the time series data,
or an object of class \sQuote{pomp},
i.e., the output of another \pkg{pomp} calculation.
Internally, \code{data} will be coerced to an array with storage-mode \code{double}.}

\item{probes}{a single probe or a list of one or more probes.
A probe is simply a scalar- or vector-valued function of one argument that can be applied to the data array of a \sQuote{pomp}.
A vector-valued probe must always return a vector of the same size.
A number of useful probes are provided with the package:
see \link[=basic_probes]{basic probes}.}

\item{nsim}{the number of model simulations to be computed.}

\item{seed}{optional integer;
if set, the pseudorandom number generator (RNG) will be initialized with \code{seed}.
The RNG will be restored to its original state afterward.}

\item{params}{optional; named numeric vector of parameters.
This will be coerced internally to storage mode \code{double}.}

\item{rinit}{simulator of the initial-state distribution.
This can be furnished either as a C snippet, an \R function, or the name of a pre-compiled native routine available in a dynamically loaded library.
Setting \code{rinit=NULL} sets the initial-state simulator to its default.
For more information, see \link[=rinit_spec]{rinit specification}.}

\item{rprocess}{simulator of the latent state process, specified using one of the \link[=rprocess_spec]{rprocess plugins}.
Setting \code{rprocess=NULL} removes the latent-state simulator.
For more information, see \link[=rprocess_spec]{rprocess specification for the documentation on these plugins}.}

\item{rmeasure}{simulator of the measurement model, specified either as a C snippet, an \R function, or the name of a pre-compiled native routine available in a dynamically loaded library.
Setting \code{rmeasure=NULL} removes the measurement model simulator.
For more information, see \link[=rmeasure_spec]{rmeasure specification}.}

\item{...}{additional arguments are passed to \code{\link{pomp}}.}

\item{verbose}{logical; if \code{TRUE}, diagnostic messages will be printed to the console.}
}
\value{
\code{probe} returns an object of class \sQuote{probed_pomp}, which contains the data and the model, together with the results of the \code{probe} calculation.
}
\description{
Probe a partially-observed Markov process by computing summary statistics
and the synthetic likelihood.
}
\details{
\code{probe} applies one or more \dQuote{probes} to time series data and
model simulations and compares the results.  It can be used to diagnose
goodness of fit and/or as the basis for \dQuote{probe-matching}, a
generalized method-of-moments approach to parameter estimation.

A call to \code{probe} results in the evaluation of the probe(s) in
\code{probes} on the data.  Additionally, \code{nsim} simulated data sets
are generated (via a call to \code{\link{simulate}}) and
the probe(s) are applied to each of these.  The results of the probe
computations on real and simulated data are stored in an object of class
\sQuote{probed_pomp}.

When \code{probe} operates on a probe-matching objective function (a \sQuote{probe_match_objfun} object), by default, the
random-number generator seed is fixed at the value given when the objective function was constructed.
Specifying \code{NULL} or an integer for \code{seed} overrides this behavior.
}
\section{Methods}{

The following methods are available.
\describe{
\item{\code{plot}}{ displays diagnostic plots.  }
\item{\code{summary}}{ displays summary information.
The summary includes quantiles (fractions of simulations with probe values less than those realized on the data) and the corresponding two-sided p-values.
In addition, the \dQuote{synthetic likelihood} (Wood 2010) is computed,
under the assumption that the probe values are multivariate-normally distributed.  }
\item{\code{logLik}}{ returns the synthetic likelihood for the probes.
NB: in general, this is not the same as the likelihood.  }
\item{\code{as.data.frame}}{
 coerces a \sQuote{probed_pomp} to a \sQuote{data.frame}.
 The latter contains the realized values of the probes on the data and on the simulations.
The variable \code{.id} indicates whether the probes are from the data or simulations.  }
}
}

\section{Note for Windows users}{


Some Windows users report problems when using C snippets in parallel computations.
These appear to arise when the temporary files created during the C snippet compilation process are not handled properly by the operating system.
To circumvent this problem, use the \code{\link[=pomp]{cdir}} and \code{\link[=pomp]{cfile}} options to cause the C snippets to be written to a file of your choice, thus avoiding the use of temporary files altogether.
}

\references{
\Kendall1999

\Wood2010
}
\seealso{
More on \pkg{pomp} elementary algorithms: 
\code{\link{elementary_algorithms}},
\code{\link{kalman}},
\code{\link{pfilter}()},
\code{\link{pomp-package}},
\code{\link{simulate}()},
\code{\link{spect}()},
\code{\link{trajectory}()},
\code{\link{wpfilter}()}

More on methods based on summary statistics: 
\code{\link{abc}()},
\code{\link{basic_probes}},
\code{\link{nlf}},
\code{\link{probe_match}},
\code{\link{spect}()},
\code{\link{spect_match}}
}
\author{
Daniel C. Reuman, Aaron A. King
}
\concept{elementary algorithms}
\concept{summary statistic-based methods}
\concept{synthetic likelihood}
