% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/mutate.R, R/transmute.R
\name{mutate}
\alias{mutate}
\alias{transmute}
\title{Create or transform variables}
\usage{
mutate(.data, ...)

transmute(.data, ...)
}
\arguments{
\item{.data}{A \code{data.frame}.}

\item{...}{Name-value pairs of expressions, each with length \code{1L}. The name of each argument will be the name of a
new column and the value will be its corresponding value. Use a \code{NULL} value in ‘mutate’ to drop a variable. New
variables overwrite existing variables of the same name.}
}
\description{
\code{mutate()} adds new variables and preserves existing ones; \code{transmute()} adds new variables and drops existing ones.
Both functions preserve the number of rows of the input. New variables overwrite existing variables of the same name.
}
\examples{
mutate(mtcars, mpg2 = mpg * 2)
mtcars \%>\% mutate(mpg2 = mpg * 2)
mtcars \%>\% mutate(mpg2 = mpg * 2, cyl2 = cyl * 2)

transmute(mtcars, mpg2 = mpg * 2)
mtcars \%>\% transmute(mpg2 = mpg * 2, cyl2 = cyl * 2)

}
