% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/across.R
\name{across}
\alias{across}
\alias{if_any}
\alias{if_all}
\title{Apply a function (or functions) across multiple columns}
\usage{
across(.cols = everything(), .fns = NULL, ..., .names = NULL)

if_any(.cols, .fns = NULL, ..., .names = NULL)

if_all(.cols, .fns = NULL, ..., .names = NULL)
}
\arguments{
\item{.fns}{Functions to apply to each of the selected columns.
Possible values are:
\itemize{
\item \code{NULL}, to returns the columns untransformed.
\item A function, e.g. \code{mean}.
\item A lambda, e.g. \code{~ mean(.x, na.rm = TRUE)}
\item A list of functions/lambdas, e.g. \verb{list(mean = mean, n_miss = ~ sum(is.na(.x))}
}

Within these functions you can use \code{\link[=cur_column]{cur_column()}} and \code{\link[=cur_group]{cur_group()}} to access the current column and grouping keys
respectively.}

\item{...}{Additional arguments for the function calls in \code{.fns}.}

\item{.names}{\code{character(n)}. Currently limited to specifying a vector of names to use for the outputs.}

\item{cols, .cols}{<\code{\link[=select_helpers]{poor-select}}> Columns to transform. Because \code{across()} is used within functions
like \code{summarise()} and \code{mutate()}, you can't select or compute upon grouping variables.}
}
\value{
\code{across()} returns a \code{data.frame} with one column for each column in \code{.cols} and each function in \code{.fns}.

\code{if_any()} and \code{if_all()} return a logical vector.
}
\description{
\code{across()} makes it easy to apply the same transformation to multiple columns, allowing you to use \code{\link[=select]{select()}}
semantics inside in "data-masking" functions like \code{\link[=summarise]{summarise()}} and \code{\link[=mutate]{mutate()}}.

\code{if_any()} and \code{if_all()} are used to apply the same predicate function to a selection of columns and combine the
results into a single logical vector.

\code{across()} supersedes the family of {dplyr} "scoped variants" like \code{summarise_at()}, \code{summarise_if()}, and
\code{summarise_all()} and therefore these functions will not be implemented in {poorman}.
}
\examples{
# across() -----------------------------------------------------------------
iris \%>\%
  group_by(Species) \%>\%
  summarise(across(starts_with("Sepal"), mean))
iris \%>\%
  mutate(across(where(is.factor), as.character))

# Additional parameters can be passed to functions
iris \%>\%
  group_by(Species) \%>\%
  summarise(across(starts_with("Sepal"), mean, na.rm = TRUE))

# A named list of functions
iris \%>\%
  group_by(Species) \%>\%
  summarise(across(starts_with("Sepal"), list(mean = mean, sd = sd)))

# Use the .names argument to control the output names
iris \%>\%
  group_by(Species) \%>\%
  summarise(
    across(starts_with("Sepal"),
    mean,
    .names = c("mean_sepal_length", "mean_sepal_width"))
  )

# if_any() and if_all() ----------------------------------------------------
iris \%>\%
  filter(if_any(ends_with("Width"), ~ . > 4))
iris \%>\%
  filter(if_all(ends_with("Width"), ~ . > 2))

}
