% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/group_by.R, R/ungroup.R
\name{group_by}
\alias{group_by}
\alias{ungroup}
\title{Group by one or more variables}
\usage{
group_by(.data, ..., .add = FALSE, .drop = group_by_drop_default(.data))

ungroup(x, ...)
}
\arguments{
\item{.data}{\code{data.frame}. The data to group.}

\item{...}{One or more unquoted column names to group/ungroup the data by.}

\item{.add}{\code{logical(1)}. When \code{FALSE} (the default) \code{group_by()} will override existing groups. To add to existing
groups, use \code{.add = TRUE}.}

\item{.drop}{\code{logical(1)}. Drop groups formed by factor levels that don't appear in the data? The default is \code{TRUE}
except when \code{.data} has been previously grouped with \code{.drop = FALSE}. See \code{\link[=group_by_drop_default]{group_by_drop_default()}} for details.}

\item{x}{A \code{data.frame}.}
}
\value{
When using \code{\link[=group_by]{group_by()}}, a \code{data.frame}, grouped by the grouping variables.

When using \code{\link[=ungroup]{ungroup()}}, a \code{data.frame}.
}
\description{
Determine the groups within a \code{data.frame} to perform operations on. \code{\link[=ungroup]{ungroup()}} removes the grouping levels.
}
\examples{
group_by(mtcars, am, cyl)
ungroup(mutate(group_by(mtcars, am, cyl), sumMpg = sum(mpg)))
mtcars \%>\%
  group_by(am, cyl) \%>\%
  mutate(sumMpg = sum(mpg)) \%>\%
  ungroup()
mtcars \%>\%
  group_by(carb) \%>\%
  filter(any(gear == 5))

# You can group by expressions: this is just short-hand for
# a mutate() followed by a group_by()
mtcars \%>\% group_by(vsam = vs + am)

}
