% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/aggregating.R
\name{setaggre}
\alias{setaggre}
\title{Set 'aggre' attributes to an object by modifying in place}
\usage{
setaggre(x, values = NULL, by = setdiff(names(x), values))
}
\arguments{
\item{x}{a \code{data.frame} or \code{data.table}}

\item{values}{a character string vector; the names of value variables}

\item{by}{a character string vector; the names of variables by which 
\code{values} have been tabulated}
}
\description{
Coerces an R object to an \code{aggre} object, identifying
the object as one containing aggregated counts, person-years and other
information. \code{setaggre} modifies in place without taking any copies.
Retains all other attributes.
}
\details{
\code{setaggre} sets \code{x} to the \code{aggre} class in place 
without taking a copy as e.g. \code{as.data.frame.XXX} functions do; see e.g. 
\code{\link[data.table]{setDT}}.
}
\examples{
df <- data.frame(sex = rep(c("male", "female"), each = 5), 
                 obs = rpois(10, rep(7,5, each=5)), 
                 pyrs = rpois(10, lambda = 10000))
setaggre(df, values = c("obs", "pyrs"), by = "sex")
}
\author{
Joonas Miettinen
}
\seealso{
\code{\link{as.aggre}}
}

