% Generated by roxygen2 (4.0.1): do not edit by hand
\name{eqnForMin}
\alias{eqnForMin}
\title{Evaluate the function to be minimised}
\usage{
eqnForMin(c.val, lambda = 0.5, alpha = 0.05, min.loc = "infty", n, p,
  k = 1, var.known = TRUE)
}
\arguments{
\item{c.val}{The value at which to evaluate the appropriate function.}

\item{lambda}{The value of lambda under consideration. This must be a scalar
between 0 and 1.}

\item{alpha}{The desired confidence coefficient.}

\item{min.loc}{The location of the minimum, either at 'zero' or 'infty'.}

\item{n}{The number of replications per population.}

\item{p}{The number of populations considered. This must be present if
min.loc is equal to 'zero'.}

\item{k}{The number of populations selected.}

\item{var.known}{A logical flag indicating if the variance of the
observations is known exactly. It is TRUE by default.}
}
\value{
The function returns a scalar value.
}
\description{
This will evaluate the appropriate function for determining the c value in the
confidence interval for \eqn{X_(1)}.
}
\details{
This function will choose the correct equation to use for
determining the smallest c-value that maintains the desired coverage
probability. Note that this function does *not* do the minimization. That
procedure is done by \code{\link{optimalC}}.

There are essentially 8 different cases to consider. They correspond to the
cases when the variance is known or unknown, when the number of populations
selected is greater than 1 or equal to 1, and when the minimum of the equation
is located at infinity or 0.
}

