% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/series-funs.R
\name{list_series}
\alias{list_series}
\title{Retrieve the count series names}
\usage{
list_series(path = ".")
}
\arguments{
\item{path}{a \code{character} string. The directory in which count series have
been saved by the function \code{\link[=format_data]{format_data()}}.}
}
\value{
A vector of count series names (\code{character} strings).
}
\description{
This function retrieves the count series names generated by
the function \code{\link[=format_data]{format_data()}}.
}
\examples{
## Load Garamba raw dataset ----
file_path <- system.file("extdata", "garamba_survey.csv", 
                         package = "popbayes")
                         
garamba <- read.csv(file = file_path)

## Create temporary folder ----
temp_path <- tempdir()

## Format dataset ----
garamba_formatted <- popbayes::format_data(garamba, path = temp_path)

## Retrieve count series names ----
popbayes::list_series(path = temp_path)
}
