% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/series-funs.R
\name{series_to_df}
\alias{series_to_df}
\title{Extract original/converted count series data from a list}
\usage{
series_to_df(data, converted = TRUE)
}
\arguments{
\item{data}{a named \code{list}. The output of \code{\link[=format_data]{format_data()}} or
\code{\link[=filter_series]{filter_series()}}.}

\item{converted}{a \code{logical}. If \code{TRUE} (default) extracts converted counts,
otherwise returns original counts.}
}
\value{
A \code{data.frame}.
}
\description{
From the output of the function \code{\link[=format_data]{format_data()}} (or \code{\link[=filter_series]{filter_series()}}), this
function extracts \code{data.frame} containing converted counts
(\code{converted = TRUE}) or original counts (\code{converted = FALSE}) for one,
several, or all count series.

The resulting \code{data.frame} has no particular use in \code{popbayes} but it can be
useful for users.
}
\examples{
## Load Garamba raw dataset ----
file_path <- system.file("extdata", "garamba_survey.csv", 
                         package = "popbayes")
                         
garamba <- read.csv(file = file_path)

## Create temporary folder ----
temp_path <- tempdir()

## Format dataset ----
garamba_formatted <- popbayes::format_data(garamba, path = temp_path)

## Extract converted count data ----
converted_data <- popbayes::series_to_df(garamba_formatted, 
                                         converted = TRUE)

## Extract original count data ----
original_data <- popbayes::series_to_df(garamba_formatted, 
                                        converted = FALSE)

dim(converted_data)
dim(original_data)
dim(garamba)
}
