% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summarize_ants.R
\name{colony_presence_absence}
\alias{colony_presence_absence}
\title{Ant Colony Presence Absence}
\usage{
colony_presence_absence(path = "~", level = "Site", rare_sp = F,
  unknowns = F, download_if_missing = TRUE)
}
\arguments{
\item{path}{path to location of downloaded Portal data; or "repo" to
retrieve data from github repo}

\item{level}{level at which to summarize data: 'Site', 'Plot', or 'Stake'}

\item{rare_sp}{include rare species (T) or not (F).
Rare species may or may not have been censused in all years. Setting rare_sp=F gives a more conservative estimate of presence/absence}

\item{unknowns}{include unknown species (T) or not (F). Unknowns include those only identified to genus.}

\item{download_if_missing}{if the specified file path doesn't have the
PortalData folder, then download it}
}
\value{
data frame with year, species, (plot if applicable), and presence [1, 0, NA]
}
\description{
Get ant species presence/absence by year/plot/stake from colony census data

Anomalies in ant colony census protocol over the years means that it can be difficult to discern true absences
of all species in all years.  This function uses information from Portal_ant_species.csv and Portal_ant_dataflags.csv
to predict true presence/absence of species per plot per year.  If a more conservative estimate is desired,
setting the argument 'rare_sp = T' will only include species we are confident were censused regularly. Setting
'rare_sp = F' may include some false absences, since it is unknown if some rare species were censused in all years.
Unknowns may also be excluded from output if desired.
}
