% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utilities.R
\name{return_if_null}
\alias{return_if_null}
\title{If a Value is NULL, Trigger the Parent Function's Return}
\usage{
return_if_null(x, value = NULL)
}
\arguments{
\item{x}{Focal input.}

\item{value}{If \code{x} is \code{NULL}, \code{\link{return}} this input from the parent function.}
}
\value{
If \code{x} is not \code{NULL}, \code{NULL} is returned. If \code{x} is \code{NULL}, the result of \code{\link{return}} with \code{value} as its input evaluated within the parent function's environment is returned.
}
\description{
If the focal input is \code{NULL}, return \code{value} from the parent function. Should only be used within a function.
}
\examples{
 ff <- function(x = 1, null_return = "hello"){
   return_if_null(x, null_return)
   x
 }
 ff()
 ff(NULL)

}
