% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/BuildBubleyDyerSeparationGenerator.R
\name{BuildBubleyDyerSeparationGenerator}
\alias{BuildBubleyDyerSeparationGenerator}
\title{Generator of an approximated separation matrix.}
\usage{
BuildBubleyDyerSeparationGenerator(poset, seed, type, ...)
}
\arguments{
\item{poset}{Object of S4 class \code{POSet} representing the poset whose separation matrices are to be computed.
Argument \code{poset} must be created by using any function contained in the package aimed at building object of S4 class \code{POSet}
(e.g. \code{\link[=POSet]{POSet()}}, \code{\link[=LinearPOSet]{LinearPOSet()}}, \code{\link[=ProductPOSet]{ProductPOSet()}}, ...) .}

\item{seed}{Positive integer to initialize the random linear extension generation.}

\item{type}{type of separation to be computed. Possible choices are:
"symmetric", "asymmetricLower", "asymmetricUpper", "vertical", "horizontal".}

\item{...}{additional types of separations to be computed. Possible choices are:
"symmetric", "asymmetricLower", "asymmetricUpper", "vertical", "horizontal".}
}
\value{
An object of S4 class \code{BubleyDyerSeparationGenerator}.
}
\description{
Creates an object of S4 class \code{BubleyDyerSeparationGenerator} for the computation of approximated
separation matrices, starting from a set of random linear extensions, sampled according to the Bubley-Dyer procedure (see Bubley and Dyer, 1999)
Actually, this function does not compute the separation matrices, but just the object that will compute them,
by using function \code{BubleyDyerSeparation}.
}
\details{
The symmetric separation associated to elements \eqn{a} and \eqn{b} in the input poset is the average
absolute difference between the positions of \eqn{a} and \eqn{b} observed in the sampled linear extensions (whose elements are arranged in ascending order):

\eqn{Sep_{ab}=\frac{1}{n}\sum_{i^1}^{n}|Pos_{l_i}(a)-Pos_{l_i}(b)|},

where \eqn{n} is the numbers of sampled linear extensions;
\eqn{l_i} represents a sampled linear extension and \eqn{Pos_{l_i}(\cdot)} stands for the position of element \eqn{\cdot}
into the sequence of poset elements arranged in increasing order according to \eqn{l_i}.

Asymmetric lower and upper separations are defined as:
\eqn{Sep_{a < b}=\frac{1}{n}\sum_{i^1}^{n}(Pos_{l_i}(b)-Pos_{l_i}(a))\mathbb{1}(a <_{l_i} b)},
\eqn{Sep_{b < a}=\frac{1}{n}\sum_{i^1}^{n}(Pos_{l_i}(a)-Pos_{l_i}(b))\mathbb{1}(b <_{l_i} a)},
where \eqn{a\leq_{l_i} b} means that \eqn{a} is lower or equal to \eqn{b} in the linear order defined by linear
extension \eqn{l_i} and \eqn{\mathbb{1}} is the indicator function. Note that \eqn{Sep_{ab}=Sep_{a < b}+Sep_{a < b}}.

Vertical and horizontal separations (\eqn{vSep} and \eqn{hSep}, respectively) are defined as

\eqn{vSep_{ab}=|Sep_{a < b}-Sep_{b < a}|} and #' \eqn{hSep_{ab}=Sep_{ab}-vSep_{ab}|}.

For a detailed explanation on why \eqn{vSep} and \eqn{hSep} can be interpreted as vertical and horizontal components
of the separation between two poset elements, see Fattore et. al (2024).
}
\examples{
el <- c("a", "b", "c", "d")

dom <- matrix(c(
  "a", "b",
  "c", "b",
  "b", "d"
), ncol = 2, byrow = TRUE)

pos <- POSet(elements = el, dom = dom)

BDgen <- BuildBubleyDyerSeparationGenerator(pos, seed = NULL,
              type="symmetric", "asymmetricUpper", "vertical")

}
\references{
Bubley, R., Dyer, M. (1999). Faster random generation of linear extensions.
Discrete Mathematics, 201, 81-88. https://doi.org/10.1016/S0012-365X(98)00333-1

Fattore, M., De Capitani, L., Avellone, A., and Suardi, A. (2024).
A fuzzy posetic toolbox for multi-criteria evaluation on ordinal data systems.
Annals of Operations Research, https://doi.org/10.1007/s10479-024-06352-3.
}
