% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/LiftingPOSet.R
\name{LiftingPOSet}
\alias{LiftingPOSet}
\title{Lifting posets.}
\usage{
LiftingPOSet(poset, element)
}
\arguments{
\item{poset}{An object of S4 class \code{POSet}.
Argument \code{poset1} must be created by using any function contained in the package aimed at building object of S4 class \code{POSet}
(e.g. \code{\link[=POSet]{POSet()}}, \code{\link[=LinearPOSet]{LinearPOSet()}}, \code{\link[=ProductPOSet]{ProductPOSet()}}, ...).}

\item{element}{A character string (the name of the added bottom).}
}
\value{
The lifted poset, an object of S4 class \code{POSet}.
}
\description{
Lifts the input poset, i.e. adds a (possibly new) bottom element to it.
}
\examples{
elems <- c("a", "b", "c", "d")

doms <- matrix(c(
  "a", "b",
  "c", "b",
  "b", "d"
), ncol = 2, byrow = TRUE)

pos <- POSet(elements = elems, dom = doms)

#Lifting
lifted.pos <- LiftingPOSet(pos, "bot")

}
