% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/junrui.edit.R
\name{ExtCos2}
\alias{ExtCos2}
\title{Extended Cosinor Model for Circadian Rhythmicity}
\usage{
ExtCos2(x, logtransform = TRUE)
}
\arguments{
\item{x}{\code{vector} vector of dimension n*1440 which reprsents n days of 1440 minute activity data}

\item{logtransform}{Conduct log transfomation before. Default is \code{TRUE}.}
}
\value{
A list with elements
\item{min}{minimum}
\item{amp}{amplitude}
\item{alpha}{alpha parameter:determines whether the peaks of the curve are wider than the troughs}
\item{beta}{beta parameter: determines whether the function rises and falls more steeply than the cosine curve}
\item{acro}{acrophase}
\item{F_imp}{pseudo-F statistics}
}
\description{
A parametric approach to study circadian rhythmicity assuming cosinor shape.
Here we used the anti logistic transformed cosine curves, which provided 5 parameters.
}
