% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hstore.R
\name{\%->\%}
\alias{\%->\%}
\alias{\%->\%<-}
\title{Extract or replace hstore values by key}
\usage{
hstore \%->\% key

hstore \%->\% key <- value
}
\arguments{
\item{hstore}{A hstore (i.e. list of lists).}

\item{key}{Character string corresponding to a key in \code{hstore}.}

\item{value}{Vector of values of the same length as \code{hstore}.}
}
\value{
For the extract version, a vector of the same length as \code{hstore},
 containing the value corresponding to \code{key} for each record
 (or \code{NA} if none). For the replace version, the modified hstore.
}
\description{
Operator to get or set values corresponding to a given key for all records
in a hstore.
}
\details{
Based on the hstore "\code{->}" operator in PostgreSQL, the \code{\%->\%}
operator returns values associated with a given key for all records in the
hstore. The assignment version of the operator i.e.
\code{hstore \%->\% key <- value} either creates a new key-value pair or,
if they key exists, update the associated value. It can also delete a key
by assigning its value to NULL.

Note that to subset the records in \code{hstore} to which the operator applies,
you must use single brackets so that the result remains a list of lists. See
below for usage examples.
}
\examples{
contacts <- data.frame(name = c("Anne", "Bert", "Chris"))
contacts$phone <- new_hstore(3)
contacts$phone \%->\% "home" <- c("555-123-4567", "555-923-9134", "555-276-1123")
contacts$phone[2:3] \%->\% "home"

contacts$phone[2] \%->\% "home" <- NULL
contacts$phone \%->\% "home"
contacts$phone[2] \%->\% "cell" <- "555-889-9134"
contacts$phone \%->\% "cell"

}
\seealso{
\code{\link{new_hstore}} to create a empty hstore.
}
