% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/extract_variable_matrix.R
\name{extract_variable_matrix}
\alias{extract_variable_matrix}
\alias{extract_variable_matrix.default}
\alias{extract_variable_matrix.draws}
\alias{extract_variable_matrix.draws_df}
\alias{extract_variable_matrix.draws_list}
\alias{extract_variable_matrix.draws_rvars}
\title{Extract matrix of a single variable}
\usage{
extract_variable_matrix(x, variable, ...)

\method{extract_variable_matrix}{default}(x, variable, ...)

\method{extract_variable_matrix}{draws}(x, variable, ...)

\method{extract_variable_matrix}{draws_df}(x, variable, ...)

\method{extract_variable_matrix}{draws_list}(x, variable, ...)

\method{extract_variable_matrix}{draws_rvars}(x, variable, ...)
}
\arguments{
\item{x}{(draws) A \code{draws} object or another \R object for which the method
is defined.}

\item{variable}{(string) The name of the variable to extract. Must include
indices for array variables (e.g. \code{"x[1]"}, \code{"y[1,2]"}). To extract all
dimensions from variables with indices, use \code{\link[=extract_variable_array]{extract_variable_array()}}.}

\item{...}{Arguments passed to individual methods (if applicable).}
}
\value{
A \code{matrix} with dimension iterations x chains.
}
\description{
Extract an iterations x chains matrix of draws of a single variable.
This is primarily used for convergence diagnostic functions such as \code{\link[=rhat]{rhat()}}.
}
\examples{
x <- example_draws()
mu <- extract_variable_matrix(x, variable = "mu")
dim(mu)
rhat(mu)

}
\seealso{
Other variable extraction methods: 
\code{\link{extract_variable}()},
\code{\link{extract_variable_array}()}
}
\concept{variable extraction methods}
