% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.loo.poth.R
\name{plot.loo.poth}
\alias{plot.loo.poth}
\title{Plot results of leave-one-out method}
\usage{
\method{plot}{loo.poth}(x, labels = TRUE, digits = 3, ...)
}
\arguments{
\item{x}{R object of class \code{poth}.}

\item{labels}{A logical indicating whether treatment names should be
shown in the plot.}

\item{digits}{Minimal number of significant digits for global POTH, see
\code{\link{print.default}}.}

\item{\dots}{Additional arguments (ignored).}
}
\value{
A ggplot2 object.
}
\description{
Plot results of leave-one-out method for precision of treatment hierarchy (POTH) metric
}
\details{
Plot results of leave-one-out method for precision of treatment hierarchy (POTH) metric
(Wigle et al., 2024).
}
\examples{
library("netmeta")
data(smokingcessation)
p1 <- pairwise(list(treat1, treat2, treat3),
  event = list(event1, event2, event3), n = list(n1, n2, n3),
  data = smokingcessation, sm = "OR")
net1 <- netmeta(p1, random = FALSE)

# Leave-one-out method
loo1 <- loo(poth(net1))
loo1
plot(loo1)

\donttest{
data(Senn2013)
net2 <- netmeta(TE, seTE, treat1.long, treat2.long, studlab,
                data = Senn2013, sm = "MD", random = FALSE)

# Leave-one-out method (without sorting by ranking metric)
loo2 <- loo(poth(net2), sort = FALSE)
loo2
plot(loo2)
}
}
\references{
Wigle, A., Béliveau, A., Salanti, G., Rücker, G., Schwarzer, G., Mavridis, D.,
Nikolakopoulou, A. (2024):
Precision of Treatment Hierarchy: A Metric for Quantifying Uncertainty in Treatment
Hierarchies in Network Meta-Analysis
}
\author{
Augustine Wigle \email{amhwigle@uwaterloo.ca},
  Guido Schwarzer \email{guido.schwarzer@uniklinik-freiburg.de}
}
