% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/power4test_by_pop_es.R
\name{power4test_by_es}
\alias{power4test_by_es}
\alias{c.power4test_by_es}
\alias{as.power4test_by_es}
\alias{print.power4test_by_es}
\title{Power By Effect Sizes}
\usage{
power4test_by_es(
  object,
  pop_es_name = NULL,
  pop_es_values = NULL,
  progress = TRUE,
  ...,
  by_seed = NULL,
  by_nrep = NULL,
  save_sim_all = TRUE
)

\method{c}{power4test_by_es}(..., sort = TRUE, skip_checking_models = FALSE)

as.power4test_by_es(original_object, pop_es_name)

\method{print}{power4test_by_es}(x, print_all = FALSE, digits = 3, ...)
}
\arguments{
\item{object}{A \code{power4test} object,
or a \code{power4test_by_es} object.
If it is a \code{power4test_by_es} object,
the first element, which is a
\code{power4test} object, will be used
as the value of this argument.}

\item{pop_es_name}{The name of the
parameter. See the help page
of \code{\link[=ptable_pop]{ptable_pop()}} on the names for
the argument \code{pop_es}.}

\item{pop_es_values}{A numeric
vector of the population values
of the parameter specified in
\code{pop_es_names}.}

\item{progress}{Logical. Whether
progress of the simulation will be
displayed.}

\item{...}{For \code{\link[=power4test_by_es]{power4test_by_es()}},
they are arguments to be passed
to \code{\link[=power4test]{power4test()}}. For \code{\link[=c.power4test_by_es]{c.power4test_by_es()}},
they are \code{\link[=power4test_by_es]{power4test_by_es()}} outputs
to be combined together.
For the \code{print} method of the output
of \code{\link[=power4test_by_es]{power4test_by_es()}}, they are
arguments to be passed to the
\code{print} method of the output of
\code{\link[=power4test]{power4test()}} (\code{\link[=print.power4test]{print.power4test()}}).}

\item{by_seed}{If set to a number,
it will be used to generate the
seeds for each call to \code{\link[=power4test]{power4test()}}.
If \code{NULL}, the default, then seeds
will still be randomly generated but
the results cannot be easily reproduced.}

\item{by_nrep}{If set to a number,
it will be used to generate the
number of replications (\code{nrep}) for
each call to \code{\link[=power4test]{power4test()}}.
If set to a numeric vector of the
same length as \code{pop_es_values}, then these are
the \code{nrep} values for each of the
calls, allowing for different numbers
of replications for the population values.
If \code{NULL}, the default, then the
original \code{nrep} will be used.
This argument is used by
\code{\link[=x_from_power]{x_from_power()}} for efficiency, and
is rarely used when calling
this function directly.}

\item{save_sim_all}{If \code{FALSE},
the dataset in the
\code{power4test} objects are not saved,
to reduce
the size of the output. Default
is \code{TRUE}.}

\item{sort}{WHen combining the
objects, whether they will be sorted
by population values. Default is \code{TRUE}.}

\item{skip_checking_models}{Whether
the check of the data generation model
will be checked. Default is \code{TRUE}.
Should be set to \code{FALSE} only when
users are certain the they are based
on the same model, or when the model
is not saved (e.g., \code{save_sim_all}
set to \code{FALSE} when the objects
were generated).
This argument is used by
\code{\link[=x_from_power]{x_from_power()}} for efficiency, and
is rarely used when calling
the \code{c} method directly.}

\item{original_object}{The object
to be converted to a \code{power4test_by_es}
object.}

\item{x}{The object
to be printed.}

\item{print_all}{If \code{TRUE}, all
elements in \code{x}, that is, the results
of all sample sizes examined, will
be printed. If \code{FALSE}, then only
those of the first value of the
parameter
will be printed.}

\item{digits}{The numbers of digits
displayed after the decimal.}
}
\value{
The function
\code{\link[=power4test_by_es]{power4test_by_es()}} returns a
\code{power4test_by_es} object, which is a
list of \code{power4test} objects, one for
each population value of the parameter.

The method \code{\link[=c.power4test_by_es]{c.power4test_by_es()}} returns
a \code{power4test_by_es} object with
all the elements (tests for different
values of \code{pop_es_values}) combined.

The function \code{\link[=as.power4test_by_es]{as.power4test_by_es()}} returns
a \code{power4test_by_es} object converted
from the input object.

The \code{print}-method of \code{power4test_by_es}
objects returns the object invisibly.
It is called for its side-effect.
}
\description{
Estimate power for a
set of effect sizes (population
values of a model parameter).
}
\details{
The function \code{\link[=power4test_by_es]{power4test_by_es()}}
regenerates
datasets for a set of effect sizes
(population values of a model parmeter)
and does the stored tests in each of
them.

Optionally, it can also be run
on a object with no stored tests.
In this case, additional arguments
must be set to instruct \code{\link[=power4test]{power4test()}}
on the tests to be conducted.

It is usually used to examine the
power over a sets of effect sizes
(population values).

The \code{c} method of \code{power4test_by_es}
objects
is used to combine tests from different
runs of \code{\link[=power4test_by_es]{power4test_by_es()}}.

The function \code{\link[=as.power4test_by_es]{as.power4test_by_es()}}
is used to convert a \code{power4test}
object to a \code{power4test_by_es}
object, if it is not already one.
Useful when concatenating
\code{power4test} objects with
\code{power4test_by_es} objects.
}
\examples{

# Specify the model

model_simple_med <-
"
m ~ x
y ~ m + x
"

# Specify the population values

model_simple_med_es <-
"
m ~ x: m
y ~ m: l
y ~ x: n
"

sim_only <- power4test(nrep = 2,
                       model = model_simple_med,
                       pop_es = model_simple_med_es,
                       n = 100,
                       R = 40,
                       ci_type = "boot",
                       fit_model_args = list(fit_function = "lm"),
                       do_the_test = FALSE,
                       iseed = 1234)

test_out <- power4test(object = sim_only,
                       test_fun = test_indirect_effect,
                       test_args = list(x = "x",
                                        m = "m",
                                        y = "y",
                                        boot_ci = TRUE,
                                        mc_ci = FALSE))

out <- power4test_by_es(test_out,
                            pop_es_name = "y ~ m",
                            pop_es_values = c(.10, .20))
out_reject <- rejection_rates(out)
out_reject

}
\seealso{
\code{\link[=power4test]{power4test()}}
}
