% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/simulate_HD_exchange.R
\name{get_iso_probs_deut}
\alias{get_iso_probs_deut}
\title{Calculate isotopic probabilities (intensity) and mass-to-charge ratio (m/z).}
\usage{
get_iso_probs_deut(
  HD_matrices,
  maxD,
  maxND,
  isotopic_probs,
  peptide_mass,
  times,
  charge,
  pH
)
}
\arguments{
\item{HD_matrices}{list. Simulated matrices for every time point after
hydrogen-deuterium-exchange. Calculated via
\code{\link[powerHaDeX]{get_HD_matrices}} or
\code{\link[powerHaDeX]{get_HD_matrices_using_markov}}}

\item{maxD}{length of the sequence - amount of prolines}

\item{maxND}{length of the isotopic distribution - 1}

\item{isotopic_probs}{the isotopic distribution for the undeuterated peptide.}

\item{peptide_mass}{mass of the peptide + mass of H2O}

\item{times}{a vector of times at which deuteration levels will be measured
(seconds)}

\item{charge}{vector of charges of the peptide ion. If NULL, one value is
sampled from vector 2:6. Default NULL.}

\item{pH}{pH of the reaction. Default to 7.5.}
}
\value{
The output is a data frame with the variables:

\code{Exposure} (time point of measurement consistent with given HD matrix),

\code{Mz} - m/z values,

\code{Intensity} - isotopic probabilities,

\code{PH} - pH.
}
\description{
Compute the isotopic probabilities for the deuterated peptide
as a convolution of the isotopic distribution for the undeuterated peptide
and the observed isotopic distribution after hydrogen-deuterium exchange
computed by \code{get_observed_iso_dist}.
}
\details{
The m/z values for the deuterated peptide are calculated using the
\code{peptide_mass}, \code{charge} and constants - deuteron mass (1.00628)
and proton mass (1.007276). Starting from the m/z value for the monoisotopic
peak, the difference between the mass of deuteron and proton divided by the
charge of the peptide ion is added.
}
\keyword{internal}
