% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/computePower.R
\name{computePower}
\alias{computePower}
\title{Power estimation}
\usage{
computePower(X, Y, A, n, seed = 123,
Nsim = 100, nperm = 200, alpha = 0.05,
test = "R2", Y.prob = FALSE, eps = 0.01, ...)
}
\arguments{
\item{X}{data matrix where columns represent the \eqn{p} variables and
rows the \eqn{n} observations.}

\item{Y}{data matrix where columns represent the two classes and
rows the \eqn{n} observations.}

\item{A}{number of score components}

\item{n}{sample size}

\item{seed}{seed value}

\item{Nsim}{number of simulations}

\item{nperm}{number of permutations}

\item{alpha}{type I error}

\item{test}{type of test, one of \code{c("score", "mcc", "R2")}.}

\item{Y.prob}{Boolean value. Default @FALSE. IF @TRUE \code{Y} is a probability vector}

\item{eps}{Default 0.01. \code{eps} is used when \code{Y.prob = FALSE} to transform \code{Y} in a probability vector.
Default to "R2".}

\item{...}{Futher parameters see \code{\link{PLSc}}}
}
\value{
Returns the corresponding estimated power
}
\description{
estimate power for a given sample size, alpha level and number
of score components.
}
\examples{
\donttest{
datas <- simulatePilotData(nvar = 10, clus.size = c(5,5),m = 6,nvar_rel = 5,A = 2)
out <- computePower(X = datas$X, Y = datas$Y, A = 3, n = 20)
}
}
\references{
Andreella, A., Finos, L., Scarpa, B. and Stocchero, M. "Towards a power analysis for PLS-based methods" 	arXiv:2403.10289 stat.ME.
}
\author{
Angela Andreella
}
