% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/VPC.r
\name{get_VPC}
\alias{get_VPC}
\alias{get_VPC.plcp}
\title{Calculate the variance partitioning coefficient}
\usage{
get_VPC(object)

\method{get_VPC}{plcp}(object)
}
\arguments{
\item{object}{An object created by \code{\link{study_parameters}}}
}
\value{
a \code{data.frame} with class \code{plcp_VPC} containing the
 percentage of variance per level and time point. The column
 \code{between_clusters} is also the intraclass correlation for level three,
 i.e. the correlation between two subjects belonging to the same cluster at
 a specific time point. With random slopes in the model the variances per time point
 will be a quadratic function of time. \code{tot_var} is the
 percentage increase or decrease in total variance relative to baseline variance.

The \code{plot} method returns a \code{\link{ggplot}} object.
}
\description{
Calculate the variance partitioning coefficient
}
\examples{
paras <- study_parameters(n1 = 11,
                          n2 = 10,
                          n3 = 3,
                          T_end = 10,
                          icc_pre_subject = 0.5,
                          icc_pre_cluster = 0,
                          icc_slope = 0.05,
                          var_ratio = 0.03)

res <- get_VPC(paras)
res

# Plot
plot(res)
}
\references{
Goldstein, H., Browne, W., & Rasbash, J. (2002).
Partitioning variation in multilevel models.
\emph{Understanding Statistics: Statistical Issues in Psychology, Education,
and the Social Sciences, 1}(4), 223-231.
}
\seealso{
\code{\link{plot.plcp_VPC}}
}
