% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/irgtt.cont.R
\name{irgtt.cont}
\alias{irgtt.cont}
\title{Power for individually randomized group treatment trial with continuous outcome}
\usage{
irgtt.cont(
  m = NULL,
  J = NULL,
  n = NULL,
  delta = NULL,
  sd = 1,
  icc = 0,
  Theta = 1,
  alpha = 0.05,
  power = NULL,
  sides = 2,
  tol = .Machine$double.eps^0.25,
  v = FALSE
)
}
\arguments{
\item{m}{The number of subjects per cluster in the intervention arm.}

\item{J}{The total number of clusters in the intervention arm.}

\item{n}{The total number of participants in the control arm.}

\item{delta}{The difference between the intervention and control means under the alternative minus the difference under the null hypothesis.}

\item{sd}{The total standard deviation of the outcome variable in the control arm; defaults to 1.}

\item{icc}{The intraclass correlation coefficient in the treatment arm; defaults to 0.}

\item{Theta}{The ratio of the total variance in the intervention and control arms; defaults to 1.}

\item{alpha}{The significance level (type 1 error rate); defaults to 0.05.}

\item{power}{The specified level of power.}

\item{sides}{Either 1 or 2 (default) to specify a one- or two-sided hypothesis test.}

\item{tol}{The desired accuracy (convergence tolerance) for uniroot.}

\item{v}{Either TRUE for verbose output or FALSE (default) to output computed argument only.}
}
\value{
A list of the arguments (including the computed one).
}
\description{
Computes power and sample size for an individually randomized group treatment trial with
a continuous outcome, in which after individual randomization, individuals in the
intervention/treatment arm are clustered. Can solve for power, J, m, n, delta or alpha.
}
\details{
Power is solved for using noncentral t or F distribution; other quantities
(for example, sample sizes) are solved
for using normal approximation.
}
\examples{
irgtt.cont(m = 10, J = 12, n = 120, delta = 0.4, icc = 0.05, Theta = 1, power = NULL)
irgtt.cont(m = 10, J = 12, n = NULL, delta = 0.4, icc = 0.05, Theta = 1, power = 0.8)
}
