% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/irt.hte.R
\name{irt.hte}
\alias{irt.hte}
\title{Power for detecting treatment effect heterogeneity in an individually randomized trial with a continuous outcome}
\usage{
irt.hte(
  n1 = NULL,
  n.ratio = 1,
  beta = NULL,
  sd.x = NULL,
  sd.yx = NULL,
  alpha = 0.05,
  power = NULL,
  sides = 2,
  v = FALSE
)
}
\arguments{
\item{n1}{The sample size for group 1.}

\item{n.ratio}{The ratio n2/n1 between the sample sizes of two groups; defaults to 1 (equal group sizes).}

\item{beta}{The regression coefficient for the treatment-by-covariate interaction term.}

\item{sd.x}{The standard deviation of the covariate.}

\item{sd.yx}{The standard deviation of the outcome variable adjusting for the covariate.}

\item{alpha}{The significance level (type 1 error rate); defaults to 0.05.}

\item{power}{The specified level of power.}

\item{sides}{Either 1 or 2 (default) to specify a one- or two- sided hypothesis test.}

\item{v}{Either TRUE for verbose output or FALSE (default) to output computed argument only.}
}
\value{
A list of the arguments (including the computed one).
}
\description{
This function performs power and sample size calculations for detecting a treatment-by-covariate
interaction effect in a two-arm randomized trial
with a continuous outcome. Can solve for power, beta, n1 or n.ratio.
}
\details{
Shieh G (2009) Detecting interaction effects in moderated multiple regression with continuous variables:
power and sample size considerations. Organizational Research Methods 12(3):510-528.

Yang S, Li F, Starks MA, Hernandez AF, Mentz RJ, Choudhury KR (2020) Sample size requirements for detecting
treatment effect heterogeneity in cluster randomized trials. Statistics in Medicine 39:4218-4237.
}
\examples{
irt.hte(n1 = 540, n.ratio = 1, beta = 1, sd.x = 12.7, sd.yx = 71)
}
