% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/data.R
\docType{data}
\name{ppiSYR2010}
\alias{ppiSYR2010}
\title{Poverty Probability Index (PPI) lookup table for Syria}
\format{
A data frame with 8 columns and 101 rows:
\describe{
\item{\code{score}}{PPI score}
\item{\code{nu100}}{National upper poverty line (100\%)}
\item{\code{nl100}}{National lower poverty line (100\%)}
\item{\code{nu150}}{National upper poverty line (150\%)}
\item{\code{nu200}}{National upper poverty line (200\%)}
\item{\code{ppp250}}{Below $2.50 per day purchasing power parity (2005)}
\item{\code{ppp375}}{Below $3.75 per day purchasing power parity (2005)}
\item{\code{ppp500}}{Below $5.00 per day purchasing power parity (2005)}
}
}
\source{
\url{https://www.povertyindex.org}
}
\usage{
ppiSYR2010
}
\description{
Poverty Probability Index (PPI) lookup table for Syria
}
\examples{
  # Access Syria PPI table
  ppiSYR2010

  # Given a specific PPI score (from 0 - 100), get the row of poverty
  # probabilities from PPI table it corresponds to
  ppiScore <- 50
  ppiSYR2010[ppiSYR2010$score == ppiScore, ]

  # Use subset() function to get the row of poverty probabilities corresponding
  # to specific PPI score
  ppiScore <- 50
  subset(ppiSYR2010, score == ppiScore)

  # Given a specific PPI score (from 0 - 100), get a poverty probability
  # based on a specific poverty definition. In this example, the national
  # poverty line definition
  ppiScore <- 50
  ppiSYR2010[ppiSYR2010$score == ppiScore, "nl100"]

}
\keyword{datasets}
