% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/generator.R
\name{generatePP}
\alias{generatePP}
\title{Poisson process}
\usage{
generatePP(intens, Time, max.intens)
}
\arguments{
\item{intens}{Intensity function defined on [0,Time] (needs to be positive)}

\item{Time}{Final time}

\item{max.intens}{Upper bound of intensity on [0,Time]}
}
\value{
Vector of realizations of the PP
}
\description{
Generate realizations of an inhomogeneous Poisson process with an intensity function
}
\examples{
# Generate a Poisson Process with intensity function
# intens= function(x) 100*x*exp(-8*x)
# and max.intens = 5

intens <- function(x) 100*x*exp(-8*x)

poissonProcess <- generatePP(intens, Time=30, max.intens=1)

}
