% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/optimize_design.R
\name{optimize_design.calibrate_thresholds}
\alias{optimize_design.calibrate_thresholds}
\title{Custom optimization method for \code{calibrate_thresholds} objects}
\usage{
\method{optimize_design}{calibrate_thresholds}(x, type1_range = c(0.05, 0.1), minimum_power = 0.8, ...)
}
\arguments{
\item{x}{an object of class 'calibrate_thresholds', usually returned by the
\code{calibrate_thresholds} function}

\item{type1_range}{a vector specifying the minimum and maximum acceptable
type I error. Specify NULL to return the full range of resulting type I
error. Defaults to c(0.05, 0.1)}

\item{minimum_power}{a numeric between 0 and 1 specifying the minimum
acceptable power. Specify NULL to return the full range of resulting power.
Defaults to 0.8.}

\item{...}{ignored}
}
\value{
A list of length two containing details of the optimal efficiency
and optimal accuracy designs
}
\description{
Determines the optimal designs based on a variety of criteria.
The optimal efficiency design is the one with the shortest Euclidean
distance to the upper left point on a plot of the average sample size under
the null by the average sample size under the alternative. The optimal
accuracy design is the one with the shortest Euclidean distance to the
upper left point on a plot of the type I error by the power.
}
\examples{
\donttest{

# One-sample case
set.seed(123)

cal_tbl <- calibrate_thresholds(
  p_null = 0.1, p_alt = 0.3,
  n = seq(5, 25, 5), N = 25, 
  pp_threshold = c(0.9, 0.95, 0.96, 0.98),
  ppp_threshold = seq(0.05, 0.2, 0.05),
  direction = "greater", delta = NULL,
  prior = c(0.5, 0.5), S = 5000, nsim = 1000
)

optimize_design(cal_tbl)


# Two-sample case
set.seed(123)

cal_tbl2 <- 
calibrate_thresholds(
  p_null = c(0.1, 0.1), p_alt = c(0.1, 0.3),
  n = cbind(seq(5, 25, 5), seq(5, 25, 5)), N = c(25, 25), 
  pp_threshold = c(0.9, 0.95, 0.96, 0.98),
  ppp_threshold = seq(0.05, 0.2, 0.05),
  direction = "greater", delta = 0,
  prior = c(0.5, 0.5), S = 5000, nsim = 1000
)

optimize_design(cal_tbl2)
}

}
