% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/calibrate_posterior_threshold.R
\name{calibrate_posterior_threshold}
\alias{calibrate_posterior_threshold}
\title{Calibrate the posterior probability threshold}
\usage{
calibrate_posterior_threshold(
  p,
  N,
  p0,
  direction = "greater",
  delta = NULL,
  prior = c(0.5, 0.5),
  S = 5000,
  theta
)
}
\arguments{
\item{p}{vector of length two containing the probability of event in
the standard of care and experimental arm c(p0, p1) for the two-sample case;
integer of event probability for one-sample case}

\item{N}{vector of length two containing the total sample size c(N0, N1)
for two-sample case; integer of sample size so far N for one-sample case}

\item{p0}{The target value to compare to in the one-sample case. Set to
NULL for the two-sample case.}

\item{direction}{"greater" (default) if interest is in p(p1 > p0) and "less"
if interest is in p(p1 < p0) for two-sample case. For one-sample case,
"greater" if interest is in p(p > p0) and "less" if interest is in p(p < p0).}

\item{delta}{clinically meaningful difference between groups.
Typically 0 for the two-sample case. NULL for the one-sample case (default).}

\item{prior}{hyperparameters of prior beta distribution.
Beta(0.5, 0.5) is default}

\item{S}{number of samples drawn from the posterior, and number of simulated
trials. Default is 5000}

\item{theta}{The target posterior probability thresholds to consider.
Integer or vector.}
}
\value{
Returns a tibble with the posterior probability threshold(s) and
associated proportion of positive trials.
}
\description{
This function is meant to be used in the context of a
clinical trial with a binary endpoint. For a vector of possible posterior
decision thresholds, the function simulates many trials and then calculates
the average number of times the posterior probability exceeds a given
threshold. In a null case, this will result in the type I error at a given
threshold. In an alternative case, this will result in the power at a given
threshold.
}
\examples{
set.seed(123)

# Setting S = 100 for speed, in practice you would want a much larger sample

# One-sample case
calibrate_posterior_threshold(
  p = 0.1,
  N = 50,
  p0 = 0.1,
  S = 100,
  theta = c(0.9, 0.95)
  )

# Two-sample case
calibrate_posterior_threshold(
  p = c(0.1, 0.1),
  N = c(50, 50),
  p0 = NULL,
  delta = 0,
  S = 100,
  theta = c(0.9, 0.95)
  )
  
}
