\name{stressvals}
\alias{stressvals}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Stress values for different dimensions of Kruskal's MDS}
\description{
  Computes Kruskal's nonmetric multidimensional scaling
  \code{\link{isoMDS}} on \code{\link{alleleobject}} or
  \code{\link{prab}}-objects for
  different output dimensions in order to compare stress values.  
}

\usage{
  stressvals(x,mdsdim=1:12,trace=FALSE)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{x}{object of class \code{\link{alleleobject}} or \code{link{prab}}.
    generated by \code{\link{alleleinit}} or \code{\link{prabinit}}.}
  \item{mdsdim}{integer vector of MDS numbers of dimensions to be
    tried.}
  \item{trace}{logical. \code{trace}-argument for \code{\link{isoMDS}}
    (should trace information be printed during execution?).}
}


\details{
  Note that zero distances between
  non-identical objects are replaced by the smallest nonzero distance
  divided by 10 to prevent \code{\link{isoMDS}} from producing an error.
}

\value{
  A list with components
  \item{MDSstress}{vector of stress values.}
  \item{mdsout}{list of full outputs of \code{\link{isoMDS}}.}
}

\author{Christian Hennig
  \email{chrish@stats.ucl.ac.uk}
  \url{http://www.homepages.ucl.ac.uk/~ucakche}}

\examples{
  data(tetragonula)
  set.seed(112233)
  taiselect <- sample(236,40)
# Use data subset to make execution faster.
  tnb <-
  coord2dist(coordmatrix=tetragonula.coord[taiselect,],
    cut=50,file.format="decimal2",neighbors=TRUE)
  ta <- alleleconvert(strmatrix=tetragonula[taiselect,])
  tai <- alleleinit(allelematrix=ta,neighborhood=tnb$nblist)
  stressvals(tai,mdsdim=1:3)$MDSstress
}
\keyword{multivariate}% at least one, from doc/KEYWORDS




