\name{alleleinit}
\alias{alleleinit}
\alias{alleleobject}
\alias{print.alleleobject}
%- Also NEED an `\alias' for EACH other topic documented here.
\title{Diploid loci matrix initialization}
\description{
  \code{alleleinit} converts genetic data with diploid loci as generated
  by \code{\link{alleleconvert}} into an object of class
  \code{alleleobject}. \code{print.alleleobject} is a print method for such
  objects.
}

\usage{
alleleinit(file = NULL, allelematrix=NULL,
                        rows.are.individuals = TRUE, 
    neighborhood = "none", distance = "alleledist", namode="variables",
                       nachar="-", distcount=FALSE) 


\method{print}{alleleobject}(x, ...)
}
%- maybe also `usage' for other objects documented here.
\arguments{
  \item{file}{string. File name. File must be in \code{"prabclus"}
    format, see details. Either \code{file}
    or \code{allelematrix} needs to be specified.}
  \item{allelematrix}{matrix in \code{"prabclus"}-format as generated by
    \code{\link{alleleconvert}}, see details. Either \code{file}
    or \code{allelematrix} needs to be specofied. }
  \item{rows.are.individuals}{logical. If \code{TRUE}, rows are interpreted
    as individuals and columns are interpreted as loci.}
  \item{neighborhood}{A string or a list with a component for
    every individual. The
    components are vectors of integers indicating
    neighboring individuals. An individual without neighbors 
    should be assigned a vector \code{numeric(0)}. If \code{neighborhood}
    is a filename, it is attempted to read such a list from a file,
    where every row should correspond to one region (such as example
    dataset \code{nb.dat}). If
    \code{neighborhood="none"}, all neighborhoods are set to
    \code{numeric(0)}. The neighborhood can be tested by
    \code{\link{nbtest}} for consistency.}
  \item{distance}{\code{"alleledist"}
%-    \code{"chord"}, \code{"nei"},
    or \code{"none"}. The distance measure
    between individuals to compute by \code{alleleinit}.}
  \item{namode}{one of \code{"single"}, \code{"individuals"},
    \code{"variables"} , or \code{"none"}. Determines whether a
    single probability for the entry to be missing is computed for a
    single locus of an individual (\code{"single"}), a vector of
    individual-wise probabilities for loci to be missing
    (\code{"individuals"}), a vector of loci-wise probabilities for
    individuals to be missing (\code{"variables"}) or no missingness
    probability at all.}
  \item{nachar}{character denoting missing values.}
  \item{distcount}{logical. If \code{TRUE}, during distance computation
    individuals are counted on the screen.} 
  \item{x}{object of class \code{alleleobject}.}
  \item{...}{necessary for print method.}
}

\details{
  The required input format is the output format \code{"prabclus"} of
  \code{\link{alleleconvert}}. Alleles are coded by a single character,
  so diploid loci need to be pairs of characters without space between
  the two alleles (e.g., "AC"). The input needs to be an
  individuals*loci matrix or data frame (or a file that produces such
  a data frame by \code{read.table(file,stringsAsFactors=FALSE)}) 
}

\value{
  \code{alleleinit} produces 
  an object of class \code{alleleobject} (note that this is similar to
  class \code{\link{prab}}; for example both can be used with
  \code{\link{prabclust}}), which is a list with components
  \item{distmat}{distance matrix between individuals.}
  \item{amatrix}{data frame of input data with string variables in the
    input format, see details.  Note that in the
    output for an individual the whole locus is declared missing if at
    least one of its alleles is missing in the input.}
  \item{charmatrix}{matrix of characters in which there are two rows for
    every individual corresponding to the two alleles in every locus
    (column). Entries are allele codes but missing values are coded as
    \code{NA}.}  
  \item{nb}{neighborhood list, see above.}
  \item{ext.nblist}{a neighborhood list in which for every row in
    \code{charmatrix} the second row number corresponding to the
    neighboring individuals is listed.} 
  \item{n.variables}{number of loci.}
  \item{n.individuals}{number of individuals.}
  \item{n.levels}{maximum number of different alleles in a locus.}
  \item{n.species}{identical to \code{n.individuals} used for
    compatibility with \code{prabclust}.}
  \item{alevels}{character vector with all used allele codes not
    including missing values.}
  \item{leveldist}{matrix in which rows are loci, columns are alleles
    and entries are frequencies of alleles per locus.}
  \item{prab}{useless matrix of number of factor levels corresponding to
    \code{amatrix} added for compatibility with objects of class
    \code{prab}.}
  \item{regperspec}{vector of row-wise sums of \code{prab} added for
    compatibility with objects of class \code{prab}.}
  \item{specperreg}{vector of column-wise sums of \code{prab} added for
    compatibility with objects of class \code{prab}.}
  \item{distance}{string denoting the chosen distance measure, see above.}
  \item{namode}{see above.}
  \item{naprob}{probability of missing values, numeric or vector, see
    documentation of argument \code{namode}.}
  \item{nasum}{number of missing entries (individual/loci) in
    \code{amatrix}}.
  \item{nachar}{see above.}
  \item{spatial}{logical. \code{TRUE} if a neighborhood was submitted.}
}

\author{Christian Hennig
  \email{chrish@stats.ucl.ac.uk}
  \url{http://www.homepages.ucl.ac.uk/~ucakche}}

\seealso{
  \code{\link{alleleconvert}}, \code{\link{alleledist}},
  \code{\link{prabinit}}.
%-  \code{\link{neidist}}, \code{\link{chorddist}}   
}

\examples{
# Only 50 observations are used in order to have a fast example.
  data(tetragonula)
  tnb <-
  coord2dist(coordmatrix=tetragonula.coord[1:50,],cut=50,file.format="decimal2",neighbors=TRUE)
  ta <- alleleconvert(strmatrix=tetragonula[1:50,])
  tai <- alleleinit(allelematrix=ta,neighborhood=tnb$nblist)
  print(tai)
}
\keyword{spatial}% at least one, from doc/KEYWORDS
\keyword{cluster}% __ONLY ONE__ keyword per line
\keyword{manip}
