% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main_evalcurves.R
\name{run_evalcurve}
\alias{run_evalcurve}
\title{Evaluate Precision-Recall curves with specified tools and test sets}
\usage{
run_evalcurve(testset, toolset)
}
\arguments{
\item{testset}{A character vector to specify a test set generated by
\code{\link{create_testset}}.}

\item{toolset}{A character vector to specify a tool set generated by
\code{\link{create_toolset}}.}
}
\value{
A data frame with validation results.
}
\description{
The \code{run_evalcurve} function runs several tests to evaluate
   the accuracy of Precision-Recall curves.
}
\examples{
## Evaluate curves for c1, c2, c3 test sets and crv5 tool set
testset <- create_testset("curve", c("c1", "c2", "c3"))
toolset <- create_toolset(set_names = "crv5")
res1 <- run_evalcurve(testset, toolset)

}
\seealso{
\code{\link{create_testset}} to generate a test dataset.
   \code{\link{create_toolset}} to generate a tool set.
}

