% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/hyperprior.R
\name{HyperMTDi-class}
\alias{HyperMTDi-class}
\alias{HyperMTDi_lognormal}
\title{An R6 base class for hyperpriors over MTDi distributions}
\description{
An R6 base class for hyperpriors over MTDi distributions

An R6 base class for hyperpriors over MTDi distributions
}
\details{
With CPE liberating \code{precautionary} from the need for \emph{nested} simulations,
the opportunity arises for a more encapsulated treatment of MTDi scenario
generators ('hyperpriors') and their sampling. Specifically, individual
sampled scenarios need only yield two functions:
\itemize{
\item A CDF taking a dose vector \deqn{X = (X_1,...,X_d)} to probabilities
\deqn{p = (p_1,...,p_d)}
\item A function F(X,kappa) yielding a fractionation matrix $F = [0 G; H 0]$.
Crucially, this class actually represents an APPROXIMATION to the hyperprior,
via a finite set of samples from it. The use of reference classes enables us
to improve this approximation efficiently by in-place updating.
}
}
\note{
This class implements a finite approximation to the infinite
set of MTDi scenarios which it describes---an approximation
which may be improved dynamically by expanding the samples.
}
\examples{

## ------------------------------------------------
## Method `HyperMTDi_lognormal$plot`
## ------------------------------------------------

if (interactive()) {
mtdi_gen <- HyperMTDi_lognormal$new(CV = 1
                                   ,median_mtd = 5
                                   ,median_sdlog = 0.5
                                   ,units="mg/kg")
mtdi_gen$plot()
}
}
\seealso{
Documentation for \code{Cpe-class}
}
\section{Methods}{
\subsection{Public methods}{
\itemize{
\item \href{#method-new}{\code{HyperMTDi_lognormal$new()}}
\item \href{#method-resample}{\code{HyperMTDi_lognormal$resample()}}
\item \href{#method-nsamples}{\code{HyperMTDi_lognormal$nsamples()}}
\item \href{#method-extend}{\code{HyperMTDi_lognormal$extend()}}
\item \href{#method-doses}{\code{HyperMTDi_lognormal$doses()}}
\item \href{#method-skeleton}{\code{HyperMTDi_lognormal$skeleton()}}
\item \href{#method-apply}{\code{HyperMTDi_lognormal$apply()}}
\item \href{#method-avg_tox_probs}{\code{HyperMTDi_lognormal$avg_tox_probs()}}
\item \href{#method-fractionate}{\code{HyperMTDi_lognormal$fractionate()}}
\item \href{#method-plot}{\code{HyperMTDi_lognormal$plot()}}
\item \href{#method-clone}{\code{HyperMTDi_lognormal$clone()}}
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-new"></a>}}
\if{latex}{\out{\hypertarget{method-new}{}}}
\subsection{Method \code{new()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HyperMTDi_lognormal$new(CV, median_mtd, median_sdlog, units, n = 100)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{CV}}{Coefficient of variation of median MTDi}

\item{\code{median_mtd}}{Median MTDi in the population}

\item{\code{median_sdlog}}{Uncertainty in median MTDi, on log scale}

\item{\code{units}}{A short string specifying dose units}

\item{\code{n}}{Number of samples to draw}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Create a new \code{HyperMTDi} object.
}

\subsection{Returns}{
A \code{HyperMTDi} object.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-resample"></a>}}
\if{latex}{\out{\hypertarget{method-resample}{}}}
\subsection{Method \code{resample()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HyperMTDi_lognormal$resample(n)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{Number of samples to draw}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Draw fresh samples
}

\subsection{Returns}{
Self, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-nsamples"></a>}}
\if{latex}{\out{\hypertarget{method-nsamples}{}}}
\subsection{Method \code{nsamples()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HyperMTDi_lognormal$nsamples()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Get number of samples
TODO: Consider a higher-level interface to progress-bar info
}

\subsection{Returns}{
Number of samples drawn so far
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-extend"></a>}}
\if{latex}{\out{\hypertarget{method-extend}{}}}
\subsection{Method \code{extend()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HyperMTDi_lognormal$extend(n = 1)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{n}}{Number of additional MTDi scenarios to sample}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Extend the samples, typically improving the approximation
TODO: Investigate how much variance reduction QRNG yields.
}

\subsection{Returns}{
Self, invisibly
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-doses"></a>}}
\if{latex}{\out{\hypertarget{method-doses}{}}}
\subsection{Method \code{doses()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HyperMTDi_lognormal$doses(x)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{x}}{A vector of dose levels}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Set or query the vector of prespecified dose levels
}

\subsection{Returns}{
Self (invisibly), unless \code{x} is missing,
in which case the dose vector is returned.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-skeleton"></a>}}
\if{latex}{\out{\hypertarget{method-skeleton}{}}}
\subsection{Method \code{skeleton()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HyperMTDi_lognormal$skeleton(p)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{p}}{A vector of probabilities, one for each prespecified dose}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Set or query a 'skeleton' probability vector
}

\subsection{Returns}{
Self (invisibly), unless \code{p} is missing, in which case the
skeleton probabilities are returned (after being calculated from the
sample if not already set explicitly).
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-apply"></a>}}
\if{latex}{\out{\hypertarget{method-apply}{}}}
\subsection{Method \code{apply()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HyperMTDi_lognormal$apply(f, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{f}}{A closure that realizes a distribution-type function (such as
a quantile function or CDF) when evaluated in the environment defined
by any row of the sampled parameters.}

\item{\code{...}}{Arguments upon which to evaluate the enclosed function}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Apply a distribution-type function over the sampled realizations
TODO: Consider taking this method private.
}

\subsection{Returns}{
A list of values of f
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-avg_tox_probs"></a>}}
\if{latex}{\out{\hypertarget{method-avg_tox_probs}{}}}
\subsection{Method \code{avg_tox_probs()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HyperMTDi_lognormal$avg_tox_probs()}\if{html}{\out{</div>}}
}

\subsection{Details}{
Get average toxicity probabilities over the sample
}

\subsection{Returns}{
Toxicity probabilities at fixed doses, averaged over sample
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-fractionate"></a>}}
\if{latex}{\out{\hypertarget{method-fractionate}{}}}
\subsection{Method \code{fractionate()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HyperMTDi_lognormal$fractionate(cpe, kappa)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{cpe}}{An object of class \code{Cpe}}

\item{\code{kappa}}{A log-therapeutic index as in Eq (5) of Norris2020c}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Return expected counts of ordinal toxicities
}

\subsection{Returns}{
An \code{nsamples}-by-6 matrix, each row being the expected counts
for toxicity grades 0 through 5, at one sampled scenario.
}
}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-plot"></a>}}
\if{latex}{\out{\hypertarget{method-plot}{}}}
\subsection{Method \code{plot()}}{
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HyperMTDi_lognormal$plot(col = "gray", xlim = NULL, ...)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{col}}{Color of lines used to depict samples}

\item{\code{xlim}}{May be used to override the default dose-axis limits,
which span the 1\% to 99\% quantiles of all samples.}

\item{\code{...}}{Additional arguments passed onward to \code{plot}}
}
\if{html}{\out{</div>}}
}
\subsection{Details}{
Visualize the samples of a \code{HyperMTDi} object
}

\subsection{Examples}{
\if{html}{\out{<div class="r example copy">}}
\preformatted{if (interactive()) {
mtdi_gen <- HyperMTDi_lognormal$new(CV = 1
                                   ,median_mtd = 5
                                   ,median_sdlog = 0.5
                                   ,units="mg/kg")
mtdi_gen$plot()
}
}
\if{html}{\out{</div>}}

}

}
\if{html}{\out{<hr>}}
\if{html}{\out{<a id="method-clone"></a>}}
\if{latex}{\out{\hypertarget{method-clone}{}}}
\subsection{Method \code{clone()}}{
The objects of this class are cloneable with this method.
\subsection{Usage}{
\if{html}{\out{<div class="r">}}\preformatted{HyperMTDi_lognormal$clone(deep = FALSE)}\if{html}{\out{</div>}}
}

\subsection{Arguments}{
\if{html}{\out{<div class="arguments">}}
\describe{
\item{\code{deep}}{Whether to make a deep clone.}
}
\if{html}{\out{</div>}}
}
}
}
